#include "ShortRangeSensor.h"

ShortRangeSensor::ShortRangeSensor(PinName sda, PinName scl) : i2c(sda, scl)
{
    //disables ECE
    i2c.write(ADDR, SYSRANGE__RANGE_CHECK_ENABLES, 3);
}

//returns range in mm
int ShortRangeSensor::getRange()
{
    char data;
    
    i2c.write(ADDR, SYSRANGE__START_SAMPLE, 3);
    wait_ms(20);
    i2c.write(ADDR, RESULT__RANGE_VAL, 2);
    i2c.read(ADDR, &data, 1);
    
    return data;
}

int ShortRangeSensor::getStatus()
{
    char data;
    
    i2c.write(ADDR, RESULT__RANGE_STATUS, 2);
    i2c.read(ADDR, &data, 1);
    
    return data;
}

int ShortRangeSensor::getPPOffset()
{
    char data;
    
    i2c.write(ADDR, SYSRANGE__PART_TO_PART_RANGE_OFFSET, 2);
    i2c.read(ADDR, &data, 1);
    
    return data;
}

void ShortRangeSensor::setPPOffset(int offset)
{
    if(offset < -128 || offset > 128)
        return;
        
    char cmd[3];
    
    cmd[0] = SYSRANGE__PART_TO_PART_RANGE_OFFSET[0];
    cmd[1] = SYSRANGE__PART_TO_PART_RANGE_OFFSET[1];
    cmd[2] = offset;
    
    i2c.write(ADDR, cmd, 3);
}