#ifndef NAVCONTROLLER_H
#define NAVCONTROLLER_H

#include "r5map.h"
#include <stack>
#include <vector>

namespace NavController
{

class NavController
{
    public:
    NavController(int mapSize = 5);
    R5Map::direction nextExploreMove();
    R5Map::direction nextTraceMove();
    bool isDone();

    private:
    R5Map::position end;
    R5Map::direction nextExploreMove();         //calculates the next move in maze exploration
    R5Map::direction nextTraceMove();
    void updateMap();                           //records all the sensor information into the map object
    bool readSensor(R5Map::direction wall);     //returns true if there is a wall in direction "wall"
    void prepReturn();

    R5Map::R5Map map;
    stack<R5Map::direction> path;               //a record of the bots path
};
} //end namespace
#endif
