#ifndef R5_MAP
#define R5_MAP

#include <vector>

namespace R5Map
{

struct position
{
    position(int xx = 0, int yy = 0) : x(xx), y(yy) {}
    inline bool operator==(const typename ::position& rhs){return ((x==rhs.x) && (y==rhs.y)); }
    inline bool operator!=(const typename ::position& rhs){return !operator==(rhs);}
    int x,y;
};

enum wallState { OPEN, CLOSED, UNKNOWN };
enum direction { NORTH, EAST, SOUTH, WEST };

struct Cell
{
    Cell() : north(UNKNOWN), south(UNKNOWN), east(UNKNOWN), west(UNKNOWN), visited(false) {}
    wallState north;
    wallState south;
    wallState east;
    wallState west;
    bool visited ;
    int number;
};

class R5Map
{
    public:
    R5Map(int conSize = DEFAULT_SIZE);
    void setPosition(position cell);
    void setStart(position newStart);
    void setFinish(position newFin);
    void setWall(position cell, direction dir, wallState state);
    void setCurWall(direction dir, wallState state);
    void setVisited(position cell);
    void setCurVisited();
    position getPosition() const;
    position getStart() const;
    position getFinish() const;
    wallState getWall(position cell, direction dir) const;
    wallState getCurWall(direction dir) const;
    bool getVisited(position cell) const;
    bool getCurVisited() const;
    int getSize() const;
    void printMap() const;
    ~R5Map();

    private:
    static const int DEFAULT_SIZE = 5;
    Cell map[7][7];
    int size;
    position pos; //X,Y
    position start;
    position fin;
};
} //end namespace
#endif 
