#ifndef DRIVECONTROLLER_H
#define DRIVECONTROLLER_H
#include "mbed.h"
#include "LineSensors.h"

typedef enum {NORTH, EAST, SOUTH, WEST} abs_direction;
//typedef enum {FORWARD, RIGHT, BACK, LEFT} rel_direction;

class DriveController
{
public:
//private:

    typename ::abs_direction orient;
    
    PwmOut treadSpeed1;
    PwmOut treadSpeed2;
    
    DigitalOut treadDirection1;
    DigitalOut treadDirection2;
    
    LineSensors sensors;
    
    bool sensorStates[8][3];
    
    void spinTest();
    double calculateError();
    bool intersection();
    
//public:
    
    DriveController();
    void move(typename ::abs_direction dir);
    void rotate(typename ::abs_direction dir);
    typename ::abs_direction getOrient();
    void setSensors();
};

#endif