#ifndef EE3420_TIME_H
#define EE3420_TIME_H

#include "mbed.h"


/*support for internal RTC of Freedom KL46Z uses the time_t and tm data types */
#include <time.h>
time_t EE3420_time;
struct tm * EE3420_timeinfo;
/*
tm_sec  int seconds after the minute    0-61*
tm_min  int minutes after the hour  0-59
tm_hour int hours since midnight    0-23
tm_mday int day of the month    1-31
tm_mon  int months since January    0-11
tm_year int years since 1900    
tm_wday int days since Sunday   0-6
tm_yday int days since January 1    0-365
tm_isdst    int Daylight Saving Time flag
*/


/* support for DS1307 uses DS1307_data type */

#include "ds1307.h"

DS1307 EE3420_DS1307(PTE0,PTE1); // start DS1307 class and give it pins for connections of the DS1307 device

typedef struct ds1307_data
{
int sec;
int min;
int hours;
int day;
int date;
int month;
int year;
} DS1307_DATA;

DS1307_DATA EE3420_DS1307_data;

char * EE3420_weekday_names[7] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
char * EE3420_month_names[12] = {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

void show_clock_24(DS1307_DATA *tdata)
{
pc.printf("%02i:%02i:%02i, %s, %s %i, %i\r\n",tdata->hours,tdata->min,tdata->sec,EE3420_weekday_names[(tdata->day)-1],EE3420_month_names[(tdata->month)-1],tdata->date,(tdata->year)+2000 );
 
}

void format_time_string_24(DS1307_DATA *tdata, char *time_str)
{
sprintf(time_str,"%02i:%02i:%02i, %s, %s %i, %i\r\n",tdata->hours,tdata->min,tdata->sec,EE3420_weekday_names[(tdata->day)-1],EE3420_month_names[(tdata->month)-1],tdata->date,(tdata->year)+2000 );
}

void show_clock_12(DS1307_DATA *tdata)
{
char ap='a';
int hr=0;

if (tdata->hours >= 12) {ap='p';} else {ap='a';}
hr=(tdata->hours)%12;
if (hr==0) {hr=12;} 
pc.printf("%02i:%02i:%02i %c.m., %s, %s %i, %i\r\n",hr,tdata->min,tdata->sec,ap,EE3420_weekday_names[(tdata->day)-1],EE3420_month_names[(tdata->month)-1],tdata->date,(tdata->year)+2000 );
}

void format_time_string_12(DS1307_DATA *tdata, char *time_str)
{
char ap='a';
int hr=0;

if (tdata->hours >= 12) {ap='p';} else {ap='a';}
hr=(tdata->hours)%12;
if (hr==0) {hr=12;} 
sprintf(time_str,"%02i:%02i:%02i %c.m., %s, %s %i, %i\r\n",hr,tdata->min,tdata->sec,ap,EE3420_weekday_names[(tdata->day)-1],EE3420_month_names[(tdata->month)-1],tdata->date,(tdata->year)+2000 );
}



void prompt_for_time(DS1307_DATA *tdata) 
{

pc.printf("\r\nEnter the time you want to set as prompted.\r\n");

tdata->year=100;
while( (tdata->year < 0) || (tdata->year > 99))
{
pc.printf("Enter the year as a number 0-99 to represent the year 2000-2099:  ");
pc.scanf("%i",&tdata->year);
pc.printf("\r\n");
}

tdata->month=100;
while( (tdata->month < 1) || (tdata->month > 12))
{
pc.printf("Enter the month as a number 1-12 for January - December:  ");
pc.scanf("%i",&tdata->month);
pc.printf("\r\n");
}

tdata->date=100;
while( (tdata->date < 1) || (tdata->date > 31))
{
pc.printf("Enter the day of the month as a number 1-31 to represent the day of the month:  ");
pc.scanf("%i",&tdata->date);
pc.printf("\r\n");
if((tdata->month==2) && (tdata->date > 29))
{
    tdata->date=33;
    pc.printf("February has 29 days at most.\r\n");
}
if((tdata->month==2) && (tdata->date == 29) && ((tdata->year%4) !=0) && (tdata->year !=0))
{
    tdata->date=33;
    pc.printf("February has 28 days at most in non-leap years.\r\n");
}
}

tdata->day=100;
while( (tdata->day < 1) || (tdata->day > 7))
{
pc.printf("Enter the day of the week as a number 1-7 for Sunday - Saturday:  ");
pc.scanf("%i",&tdata->day);
pc.printf("\r\n");
}

int ampm=2;
tdata->hours=100;
while((tdata->hours < 0) || (tdata->hours > 23))
{
pc.printf("Enter the hour as 0-23:  ");
pc.scanf("%i",&tdata->hours);
pc.printf("\r\n");
if((tdata->hours >=1 ) && (tdata->hours <= 12) )
{
    ampm=2;
    while((ampm<0) || (ampm > 1))
    {
        pc.printf("Enter 0 for a.m. and 1 for p.m.: ");
        pc.scanf("%i",&ampm);
        pc.printf("\r\n");        
    }
    tdata->hours = (tdata->hours + (ampm*12)) % 24 ;
}
}

tdata->min=100;
while( (tdata->min < 0) || (tdata->min > 59))
{
pc.printf("Enter the minute as 0-59:  ");
pc.scanf("%i",&tdata->min);
pc.printf("\r\n");
}

tdata->sec=100;
while( (tdata->sec < 0) || (tdata->sec > 59))
{
pc.printf("Enter the second as 0-59:  ");
pc.scanf("%i",&tdata->sec);
pc.printf("\r\n");
}

}

void set_DS1307_time(DS1307_DATA *tdata)
{

if(0!=EE3420_DS1307.twentyfour_hour())
{
    pc.printf("Failed to set 24-hour mode on DS1307.\r\n");
    exit(-1);
}

if(0!=EE3420_DS1307.settime( tdata->sec, tdata->min, tdata->hours, tdata->day, tdata->date, tdata->month, tdata->year))
{
    pc.printf("Failed to set time on DS1307.\r\n");
    exit(-1);
}

}

void get_DS1307_time(DS1307_DATA *tdata) 
{
if(0!=EE3420_DS1307.gettime( &tdata->sec, &tdata->min, &tdata->hours, &tdata->day, &tdata->date, &tdata->month, &tdata->year))
{
    pc.printf("Unable to read DS1307 time\r\n");
    exit(-1);
}
}
 
void set_KL46Z_RTC_from_DS1307()
{
get_DS1307_time(&EE3420_DS1307_data); 
time(&EE3420_time);
EE3420_timeinfo = localtime ( &EE3420_time );
EE3420_timeinfo->tm_sec=EE3420_DS1307_data.sec;
EE3420_timeinfo->tm_min=EE3420_DS1307_data.min;
EE3420_timeinfo->tm_hour=EE3420_DS1307_data.hours;
EE3420_timeinfo->tm_mday=EE3420_DS1307_data.date;
EE3420_timeinfo->tm_mon=(EE3420_DS1307_data.month)-1;
EE3420_timeinfo->tm_year=(EE3420_DS1307_data.year)+100;    
EE3420_timeinfo->tm_wday=(EE3420_DS1307_data.day)-1;
//timeinfo->tm_isdst=-1;
EE3420_time=mktime(EE3420_timeinfo);
set_time(EE3420_time);     

}


 #endif /* EE3420_TIME_H */
 
 
 
 
 
 
