#include "stdio.h"
#include "stdint.h"
#include "mbed.h"
#include "Freedom_headers.h"

#define USE_PC TRUE
/* UNCOMMENT THE FOLLOWING LINE TO ENABLE SD CARD FILESYSTEM VIA DEFAULT SPI */
#define USE_SD_CARD TRUE
/* UNCOMMENT THE FOLLOWING LINE TO ENABLE DS1307 REAL-TIME CLOCK VIA IIC */
#define USE_DS1307 TRUE
/* UNCOMMENT THE FOLLOWING LINE TO ENABLE SIMPLE FIFO FUNCTIONS */
#define USE_SIMPLE_FIFO TRUE

#ifdef USE_PC
Serial pc(USBTX,USBRX);

#ifdef USE_SD_CARD
#include "SDFileSystem.h"
#define SD_MOSI PTD6
#define SD_MISO PTD7
#define SD_SCK  PTD5
#define SD_CS   PTD4
char sd_root_name[]="sd";
char filename[80];
SDFileSystem sd(SD_MOSI, SD_MISO, SD_SCK, SD_CS, sd_root_name);  /* MOSI,MISO,SCK,CS, "Name of directory structure" */

#endif /* #ifdef USE_SD_CARD*/

#ifdef USE_DS1307
#include "EE3420_time.h"

#endif /* #ifdef USE_DS1307*/

#ifdef USE_SIMPLE_FIFO

/* comment out the folloing definitions to use the library defaults */
#define SIMPLE_FIFO_SIZE 32

#include "simple_fifo.h"

#endif /* #ifdef USE_SIMPLE_FIFO*/

FIFO_FLOAT scope_data;
int samples_active=0;
float voltage_level;
float ftemp;
char timestr[80];

int sample_count=0;
    
AnalogIn voltage_sensor(PTB0);
InterruptIn left_button(PTC12);  /* button labeled SW3, wired active-low needing pull-up */
Ticker t;
#define SAMPLE_FREQUENCY 5000.0

void take_sample()
{
    if(samples_active==1)
    {    
        voltage_level=voltage_sensor.read();
        /*if(fifo_float_writable(&scope_data))
        {
        fifo_float_write(&scope_data,voltage_level);
        }
        else
        {
            printf("fifo overrun\n");
            samples_active=0;
        }*/
        
        
        sample_count++;
    }
    if(sample_count>= 2000)
    {
        samples_active=0;
    }
}

void start_sample()
{
    if(samples_active==0)
    {
        fifo_float_init(&scope_data);
        sample_count=0;
        samples_active=1;  
    }
    else
    {
        samples_active=0;
    }
    
}

int main()
{

#ifdef USE_PC    
    pc.baud(115200);    /* set serial port speed to 115200 - must be matched in terminal emulator */
#endif
#ifdef USE_SLCD
    slcd.All_Segments(0);
#endif
#ifdef USE_CHARACTER_LCD
    character_lcd_initialize();
#endif

    fifo_float_init(&scope_data);
    
#ifdef USE_PC
    pc.printf("\n");
#endif

    get_DS1307_time(&EE3420_DS1307_data);
    set_KL46Z_RTC_from_DS1307();

    sprintf(filename,"/sd/voltage.csv");
    
    FILE *fp = fopen(filename, "w");
    if(fp == NULL) 
    {
        error("Could not open file ""%s"" for write\n", filename);
    }
    fprintf(fp,"date, time, scopes\n");
    fclose(fp);

    samples_active=0;
    
    left_button.mode(PullUp);
    left_button.fall(&start_sample);

    t.attach(&take_sample,1.0/SAMPLE_FREQUENCY);

while(true)
{
    
    if(fifo_float_readable(&scope_data))
    {
        
        fp = fopen(filename, "a");
        while(fifo_float_readable(&scope_data))
        {
            //get_DS1307_time(&EE3420_DS1307_data);
            //format_time_string_24(&EE3420_DS1307_data, timestr);
            fifo_float_read(&scope_data,&ftemp);
            //fprintf(fp, "20%02i/%02i/%02i, %02i:%02i:%02i, %f\n",EE3420_DS1307_data.year,EE3420_DS1307_data.month,
            //EE3420_DS1307_data.day,EE3420_DS1307_data.hours,EE3420_DS1307_data.min,EE3420_DS1307_data.sec,ftemp);
            fprintf(fp, "%f\n",ftemp);
            pc.printf("%f\n",ftemp);
        }
        fclose(fp);  
    }
}
} //end of main()


