#include "mbed.h"
#include "LineSensors.h"
#include "DigitalInOut2.h"

LineSensors::LineSensors(PinName IO1, PinName IO2, PinName IO3, PinName IO4, PinName IO5, PinName IO6, PinName IO7, PinName IO8, 
                    PinName IO9, PinName IO10, PinName IO11, PinName IO12, PinName IO13, PinName IO14, PinName IO15, PinName IO16, 
                    PinName IO17, PinName IO18, PinName IO19, PinName IO20, PinName IO21, PinName IO22, PinName IO23, PinName IO24){
    sensors[0][0] = IO1;sensors[1][0] = IO2;sensors[2][0] = IO3;sensors[3][0] = IO4;
    sensors[4][0] = IO5;sensors[5][0] = IO6;sensors[6][0] = IO7;sensors[7][0] = IO8;
    sensors[0][1] = IO9;sensors[1][1] = IO10;sensors[2][1] = IO11;sensors[3][1] = IO12;
    sensors[4][1] = IO13;sensors[5][1] = IO14;sensors[6][1] = IO15;sensors[7][1] = IO16;
    sensors[0][2] = IO17;sensors[1][2] = IO18;sensors[2][2] = IO19;sensors[3][2] = IO20;
    sensors[4][2] = IO21;sensors[5][2] = IO22;sensors[6][2] = IO23;sensors[7][2] = IO24;

    timeOut = 100000;
}

void LineSensors::setThreshold(){
    read();
    for(int j = 0; j < 3; j++){
        for(int i = 0; i < 8; i++){
            thresh[i][j] = sensVal[i][j];
            thresh[i][j] *= 7;
        }
    }
}

void LineSensors::read(){
    DigitalInOut2 sensor(sensors[0][0]);    //attribute the first pin in the sensors array to sensor (the DigitalInOut2 object)
    
    for(int j = 0; j < 3; j++){
        for(int i = 0; i < 8; i ++){
            gpio_init_inout(&sensor.gpio, sensors[i][j], PIN_OUTPUT, PullNone, 1); //change the pin that is attributed to sensor (the DigitalInOut2 object)
            wait_us(15);
            sensor = 0;
            sensor.input();
            timer.start();
            while(sensor == 1 && timer.read_us() < timeOut){
            }
            timer.stop();
            sensVal[i][j] = timer.read_us();
            timer.reset();
        }
    }
}

void LineSensors::lineDetect(bool out[8][3]){
    read();
    for(int j = 0; j < 3; j++){
        for(int i = 0; i < 8; i++){
            if(sensVal[i][j] > thresh[i][j])
                out[i][j] = 1;
            else
                out[i][j] = 0;
        }
    }
}