#ifndef GRIPPER_H
#define GRIPPER_H

#include "mbed.h"

//definitions for servo PWM settings in us
#define GRIP_DEF 1700
#define GRIP_OPEN 1750
#define GRIP_CLOSE 1500
#define WRIST_DEF 1900
#define WRIST_UP 1900
#define WRIST_DOWN 1500
#define PWM_PER 20000

class Gripper
{
    public:
    //gripPin is pwm pin connected to gripper servo, wristPin is pwm pin connected to wrist servo
    Gripper(PinName gripPin, PinName wristPin);
    //closes gripper to fit target
    void grip();
    //fully opens gripper
    void release();
    //raises wrist to target angle
    void lift();
    //lowers wrist to grabbing angle
    void lower();
    
    private:
    PwmOut gripPwm;
    PwmOut wristPwm;
};
#endif