#include "Gripper.h"

Gripper::Gripper(PinName gripPin, PinName wristPin) : gripPwm(gripPin), wristPwm(wristPin)
{
    gripPwm.period_us(PWM_PER);
    wristPwm.period_us(PWM_PER);
    gripPwm.pulsewidth_us(GRIP_DEF);
    wristPwm.pulsewidth_us(WRIST_DEF);
}

void Gripper::grip() { gripPwm.pulsewidth_us(GRIP_CLOSE); }

void Gripper::release() { gripPwm.pulsewidth_us(GRIP_OPEN); }

void Gripper::lift() { wristPwm.pulsewidth_us(WRIST_UP); }

void Gripper::lower() { wristPwm.pulsewidth_us(WRIST_DOWN); }