#include "DistanceSensor.h"
#include <cmath>

DistanceSensor::DistanceSensor(PinName ai, int profNum) : voltage(ai)
{
    if(profNum > -1 && profNum < 4)
        prof = profNum;
    else
        prof = 1;
}

double DistanceSensor::getDistance()
{   
    double v = voltage.read(); 
    double dist;
    double k1 = 1.1577767608;
    // double k2;
    double k3 = 1.1672866347;
    double p1 = -1.1971310749;
    // double p2;
    double p3 = -1.2007193388;
    
    switch(prof)
    {
        case(1) : dist = k1*pow(v, p1);
            break;
        case(2) : dist = 0; // placeholder until unit 2 gets redone 
            break;
        case(3) : dist = k3*pow(v, p3);
            break;
        default : dist = 0;
    }
         
    return dist;
}