#ifndef DIGITALINOUT2_H
#define DIGITALINOUT2_H
 
#include "platform.h"
 
#include "gpio_api.h"
 
namespace mbed {
 
class DigitalInOut2 {
 
public:
    gpio_t gpio;    //in the stock DigitalInOut library this was protected
    
    DigitalInOut2(PinName pin) {
        gpio_init(&gpio, pin);
    }
    
    void write(int value) {
        gpio_write(&gpio, value);
    }

    int read() {
        return gpio_read(&gpio);
    }
    
    void output() {
        gpio_dir(&gpio, PIN_OUTPUT);
    }

    void input() {
        gpio_dir(&gpio, PIN_INPUT);
    }

    void mode(PinMode pull) {
        gpio_mode(&gpio, pull);
    }
    
#ifdef MBED_OPERATORS

    DigitalInOut2& operator= (int value) {
        write(value);
        return *this;
    }
    
    DigitalInOut2& operator= (DigitalInOut2& rhs) {
        write(rhs.read());
        return *this;
    }
    
    operator int() {
        return read();
    }
#endif

};
 
}
 
#endif