#ifndef COLORSENSOR_H
#define COLORSENSOR_H

#include "mbed.h"

//constants for i2c register communication
const int ADDR = 0x3A;
const char CTRL_VAL = 0x80;
const char* const CTRL = &CTRL_VAL;
const char CTRL_INIT_VAL = 0x03;
const char* const CTRL_INIT = &CTRL_INIT_VAL;
const char GAIN_VAL = 0x87;
const char* const GAIN = &GAIN_VAL;
const char GAIN_INIT_VAL = 0x10;
const char* const GAIN_INIT = &GAIN_INIT_VAL;
const char RED_LO_VAL = 0x92;
const char* const RED_LO = &RED_LO_VAL;    
const char RED_HI_VAL = 0x93;
const char* const RED_HI = &RED_HI_VAL;    
const char GRN_LO_VAL = 0x90;
const char* const GRN_LO = &GRN_LO_VAL;    
const char GRN_HI_VAL = 0x91;
const char* const GRN_HI = &GRN_HI_VAL;    
const char BLU_LO_VAL = 0x94;
const char* const BLU_LO = &BLU_LO_VAL;    
const char BLU_HI_VAL = 0x95;
const char* const BLU_HI = &BLU_HI_VAL;    
const char CLR_LO_VAL = 0x96;
const char* const CLR_LO = &CLR_LO_VAL;    
const char CLR_HI_VAL = 0x97;
const char* const CLR_HI = &CLR_HI_VAL;

class ColorSensor
{
    public:
    ColorSensor(PinName sda, PinName scl);
    int getR();
    int getG();
    int getB();
    int getC();
    void setGain(int g);
    void setScaler(int s);
    
    private:
    I2C i2c;
    int gain;
    int scale;
};
#endif