#include "mbed.h"
#include "SDFileSystem.h"

#define freq 1
#define time_interval_sec 30

#define dur_sec 20
Ticker int1;
Ticker int2;
Ticker int3;
Ticker int4;

Serial pc(USBTX, USBRX);
Serial gsm(D1, D0); //tx,rx
DigitalOut dtr(D2);
DigitalOut pwr_key(D3);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
AnalogIn AC_input(A0);
AnalogIn DC_input(A2);
AnalogIn TC_RLY(A3);
AnalogIn TC_50(A4);
AnalogIn TC_33(A5);


union Data
    {
    unsigned short datai[50000];
    char datac[100000];
    };
union Data ACdata;
union Data DCdata;

union Temp
    {
    unsigned short tempi;
    char tempc;
    };
char sitename[100] ="MOD2";
char filename[100] = "";
char timestamp[100]="";
char timestampold[100]="";
char main_dir[100] ="";
char month_dir[100]="";
char date_dir[100] ="";
char hour_dir[100] ="";
char pathAC[100]   ="";
char pathDC[100]   ="";
char pathTC[100]   ="";
char response[100] ="";
char command[100] ="";
char result[100] ="";
char FTP_File_Name[100] ="";
char FTPPUT_File_Name[100] ="";
char FTP_Path_Name[100] ="";

int dateu = 0;
int datet = 0;
int monthu = 0;
int montht = 0;
int year = 0;
int houru = 0;
int hourt = 0;
int minuteu = 0;
int minutet = 0;
int secondu = 0;
int secondt = 0;

int time_stamp = 0;
int temp = 0;
int ftp_update_flag = 1;
int data_update_flag = 1;
int name_update_flag = 1;
int c,i;

unsigned long var = 0;
unsigned long currentMillis = 0;
uint8_t x=0,z=0,  answer=0;

time_t previous;
float tempC;
uint32_t dataLength = dur_sec*freq*1000;
unsigned long j=0;


//----------------------------------------------------------------------------------------------------------------------------------

int8_t sendATcommandclk(char* ATcommand, char* expected_answer, unsigned int timeout)
{
    uint8_t x=0,answer=0;//x=0 and answer=0, if not put, AT+CCLK?\r is not executed
    char response[100];
    memset(response, '\0', 100);    // Initialize the string
    wait_ms(100);
    while( gsm.readable() > 0) gsm.getc();    // Clean the input buffer
    gsm.printf("%s \r", ATcommand);    // Send the AT command 
    pc.printf("..@");
    x = 0;
    previous = time(NULL);
    
    // this loop waits for the answer
    do{ 
        if(gsm.readable() != 0){    
            
            // if there are data in the UART input buffer, reads it and checks for the asnwer
          
            response[x] = gsm.getc();
            pc.putc(response[x]);
            x++;
            sprintf(timestamp,response);//copies response to timestamp for further processing
            
            // check if the desired answer  is in the response of the module
            if (strstr(response, expected_answer) != NULL)    
            {
            answer = 1;
            } 
        }
  
         // Waits for the asnwer with time out
    }while((answer == 0) && ((time(NULL) - previous) < timeout));
    //pc.printf("%s \r\n",response);  
    FILE *fp=fopen("/sd/TeraTerm.txt","a");
        if(fp == NULL)
        {
        error("Could not open file for write\n\r");
        }
        fprintf(fp,"%s",response);
        fclose(fp);
      return answer;
}

//----------------------------------------------------------------------------------------------------------------------------------
    
void GetFileDir()
{
    
    sendATcommandclk("AT+CCLK?\r", "OK", 5);  
    sprintf(response,timestamp);
    x=20;
    int gsmerr;
    year = 10*(timestamp[x+1]-48) + (timestamp[x+2]-48);
    while(year!=14)
    {
    wait(1);
        GetFileDir();
        pc.printf("\r\ncurrent timestamp %s\r\n",timestamp);
        
    }
    sprintf(timestampold,response);
    pc.printf("\r\nold time stamp is%s\r\n",timestampold);
    //month onwards all parameters are processed in both 'unit' and 'ten' position separately, else for numbers<10, only unit digit is printed e.g 09 is shown as 9 only
    montht = (timestamp[x+4]-48); 
    monthu = (timestamp[x+5]-48);
    datet = (timestamp[x+7]-48);
    dateu = (timestamp[x+8]-48);
    hourt = (timestamp[x+10]-48);
    houru = (timestamp[x+11]-48);
    minutet = (timestamp[x+13]-48); 
    minuteu = (timestamp[x+14]-48);
    secondt = (timestamp[x+16]-48);
    secondu = (timestamp[x+17]-48); 
    sprintf(main_dir,"/sd/%s",sitename);
    sprintf(month_dir,"%s/%s%d%d%d",main_dir,sitename,year,montht,monthu);
    sprintf(date_dir,"%s/%s%d%d%d%d%d",month_dir,sitename,year,montht,monthu,datet,dateu);
    sprintf(hour_dir,"%s/%s%d%d%d%d%d%d%d",date_dir,sitename,year,montht,monthu,datet,dateu,hourt,houru);
    if(timestamp==timestampold)
    {
    sprintf(filename,"%s/%s%d%d%d%d%d%d%d%d%d%d%dErr%d",hour_dir,sitename,year,montht,monthu,datet,dateu,hourt,houru,minutet,minuteu,secondt,secondu,gsmerr);
    gsmerr++;
    }
    else
    {
    sprintf(filename,"%s/%s%d%d%d%d%d%d%d%d%d%d%d",hour_dir,sitename,year,montht,monthu,datet,dateu,hourt,houru,minutet,minuteu,secondt,secondu);
    gsmerr=0;
    }
    mkdir(main_dir,0777);
    mkdir(month_dir,0777);
    mkdir(date_dir,0777);
    mkdir(hour_dir,0777);
    
    //pc.printf("dir are\r\nmain_dir\t%s\r\nmonth_dir\t%s\r\ndate_dir\t%s\r\nhour_dir\t%s\r\nfilename\t%s\r\n",main_dir,month_dir,date_dir,hour_dir,filename);   
}

//-------------------------------------------------------------------------------------------------------------------------------------

void temp_val()
{
union Temp TC33temp;
union Temp TC50temp;
union Temp TCRLtemp;

TC33temp.tempi=TC_33.read_u16();
TC50temp.tempi=TC_50.read_u16();
TCRLtemp.tempi=TC_RLY.read_u16();


GetFileDir();

sprintf(pathTC,"%sTC.txt",hour_dir);
pc.printf("\r\nFilename-TC\t%s", pathTC);
FILE *fp = fopen(pathTC, "a");
    
if(fp == NULL)
    {
    error("Could not open file for write\n\r");
    }
    
fprintf(fp, "\r\n20%d/%d%d/%d%d-%d%d:%d%d:%d%d",year,montht,monthu,datet,dateu,hourt,houru,minutet,minuteu,secondt,secondu);
fprintf(fp, "\r\n3.3V-%d C",TC33temp.tempi );  
fprintf(fp, "\r\n5.0V-%d C",TC50temp.tempi );  
fprintf(fp, "\r\nRlay-%d C",TCRLtemp.tempi );           
fprintf(fp, ",");
fclose(fp);
pc.printf("\r\n3.3V temp - %c C\t%d",TC33temp.tempc,TC33temp.tempi );  
pc.printf("\r\n5.0V temp - %c C\t%d",TC50temp.tempc,TC50temp.tempi);  
pc.printf("\r\nRly temp - %c C\t%d",TCRLtemp.tempc,TCRLtemp.tempi );    
FILE *fp1=fopen("/sd/TeraTerm.txt","a");
    if(fp1 == NULL)
    {
    error("Could not open file for write\n\r");
    }
    fprintf(fp1,"\r\nTemperature writing Done\n\r");
    fclose(fp1);
pc.printf("\n\rWriting Temp done \n \r"); 
 
}

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

void calculate_ADC()
{

    Timer t;
    
    pc.printf("\n\rStarting Reading \n\r");
    t.start();
    while(j<dataLength)
    {        
        if((int)(t.read()*100*freq*1000)%100 == 0)
        {
            ACdata.datai[j] = AC_input.read_u16();
            DCdata.datai[j] = DC_input.read_u16();
            ++j;
        }
    }
    
    t.stop();
    pc.printf("Time Taken %f \n\r", t.read());
    t.reset();
    pc.printf("Total Samples %d\r\n",j);
    j=0;
    
    GetFileDir();
    
    sprintf(pathAC,"%sAC.txt",filename);
    pc.printf("\r\nFilename-AC\t%s", pathAC);
    FILE *fp = fopen(pathAC, "w");
        if(fp == NULL)
        {
        error("Could not open file for write\n\r");
        }
    for(unsigned long k=0; k<dataLength; ++k)
        {
            if (k%4==0)
                {
                    fprintf(fp,"\n\n");
                }
            fprintf(fp, "%c%c", ACdata.datac[k]);
        }
    fprintf(fp, ",");
    fclose(fp);
    
    sprintf(pathDC,"%sDC.txt",filename);
    FILE *fp1 = fopen(pathDC, "w");
        if(fp1 == NULL)
        {
        error("Could not open file for write\n\r");
        }

    for(unsigned long k=0; k<dataLength; ++k)
        {
            if (k%4==0)
                {
                    fprintf(fp,"\n\n");
                }

            fprintf(fp1, "%c%c", DCdata.datac[k]);
        }
    fprintf(fp1, ",");
    fclose(fp1);
    FILE *fp2=fopen("/sd/TeraTerm.txt","a");
        if(fp2 == NULL)
        {
        error("Could not open file for write\n\r");
        }
    fprintf(fp2,"\r\nSamples writing Done\n\r");
    fclose(fp2);
    pc.printf("Writing Samples done \n \r");
        
}

//---------------------------------------------------------------------------------------------------------------------------

void reset_mod()
{
    pc.printf("\r\nresetting module\n\n\n\r\n");
    
    NVIC_SystemReset();     
}

//---------------------------------------------------------------------------------------------------------------------------
int main()
{
    mkdir("/sd/strtup", 0777);
    FILE *fp=fopen("/sd/TeraTerm.txt","a");
        if(fp == NULL)
        {
        error("Could not open file for write\n\r");
        }
        fprintf(fp,"\nHello-Module\r\n");
        fclose(fp);
    
   
    pc.printf("Hello\r\n");
    wait(2);
  
    int1.attach(&temp_val,10);
    int2.attach(&calculate_ADC,179); 
    int3.attach(&reset_mod,3601);       
    
}