// Tested : NUCLEO-F401RE NUCLEO-L476LG
#include "mbed.h"
#include<stdlib.h>

// dimensione del pacchetto di comunicazione tra PC e uC
#define PACKETDIM 64

// Definizione periferiche
Serial pc(USBTX, USBRX);

// User Button, LED  
DigitalIn myButton(USER_BUTTON);

// Output di servizio sul LED2 della scheda NUCLEO
DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);

// Output della NUCLEO e Input del DUT. Saranno inviati dal PC alla NUCLEO, nell'ordine in cui si trovano dichiarati di seguito
DigitalOut myOut1(PA_13);
DigitalOut myOut2(PA_14);
DigitalOut myOut3(PA_15);

DigitalOut myTest(PG_2);

// Input della NUCLEO e Output del DUT. Saranno inviati dalla NUCLEO al PC, nell'ordine in cui si trovano dichiarati di seguito
DigitalIn myIn1(PA_8); 
DigitalIn myIn2(PB_10); 
DigitalIn myIn3(PB_4);  
DigitalIn myIn4(PB_5);  
DigitalIn myIn5(PB_3);  

// Output di pilotaggio Relè per test CANBUS
DigitalOut myRelayH1(PB_6);
DigitalOut myRelayL1(PC_7);
DigitalOut myNotRelayH2(PA_9);     // A questo Output è collegato un OptoRelay normalmente chiuso e quindi lavora in logica negata
DigitalOut myNotRelayL2(PA_10);    // A questo Output è collegato un OptoRelay normalmente chiuso e quindi lavora in logica negata
DigitalOut myNotRelayH3(PB_8);     // A questo Output è collegato un OptoRelay normalmente chiuso e quindi lavora in logica negata
DigitalOut myRelayL3(PB_9);


// indice per i cicli
int nIndex;


// comando ricevuto dal PC attraverso la routine di gestione interrupt Rx
// 1: read all GPIO
// 2: write all GPIO
volatile int nReadCmd=0;

// stato degli input
volatile int myIn1Status;
volatile int myIn2Status;
volatile int myIn3Status;
volatile int myIn4Status;
volatile int myIn5Status;

    

//**********************************************
//          IRQ per la Rx su seriale 
//**********************************************
void RxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char caRxPacket[PACKETDIM];
    int nRxPacketSize;
    
    
    
    // pntatore al comando, nella stringa ricevuta sulla seriale 
    char* cCmdPosition;
    
    // reset array contenente pacchetto ricevuto
    nIndex=0;
    for(nIndex=0;nIndex<PACKETDIM;nIndex++)
    {
        caRxPacket[nIndex]='\0';
    }
        
    // ricevi caratteri su seriale, se disponibili   
    nRxPacketSize =0;
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        pc.scanf("%s", &caRxPacket);
        nRxPacketSize = strlen(caRxPacket);
    }
    // restituisce il comando ricevuto e la dimensione
    pc.printf("Command: %s\n\r",caRxPacket);
    pc.printf("PacketSize: %d\n\r",nRxPacketSize); 
        
    // COMANDO DI LETTURA INPUT: comando di lettura dei GPIO è "ReadGPIO"    
    // confronta il comando ricevuto con quello di Read GPIO.
    // Restituisce le seguenti stringhe:
    // "USER-BUTTON: x"; x = 0/1
    // "In1: 0/1"; x = 0/1
    // "In2: 0/1"; x = 0/1
    // "In3: 0/1"; x = 0/1
    // "In4: 0/1"; x = 0/1
    // "In5: 0/1"; x = 0/1
    nReadCmd = strcmp(caRxPacket, "ReadGPIO");
    if(nReadCmd==0)
    {
        // rileva lo stato degli input e trasmettili al PC-HOST
        pc.printf("USER-BUTTON: %d\n\r",myButton.read()); // il primo input è lo User-Button per scopi di diagnostica
        // myIn1: se legge 0/1, trasmette lo stato al PC
        if(myIn1==1)
        {
            pc.printf("In1: 1\n\r"); 
        }
        else
        {
            pc.printf("In1: 0\n\r"); 
        }
        
        // myIn2: se legge 0/1, trasmette lo stato al PC
        if(myIn2==1)
        {
            pc.printf("In2: 1\n\r"); 
        }
        else
        {
            pc.printf("In2: 0\n\r"); 
        }
        // myIn3: se legge 0/1, trasmette lo stato al PC
        if(myIn3==1)
        {
            pc.printf("In3: 1\n\r"); 
        }
        else
        {
            pc.printf("In3: 0\n\r"); 
        }
        // myIn4: se legge 0/1, trasmette lo stato al PC
        if(myIn4==1)
        {
            pc.printf("In4: 1\n\r"); 
        }
        else
        {
            pc.printf("In4: 0\n\r"); 
        }
        
        // myIn5: se legge 0/1, trasmette lo stato al PC
        if(myIn5==1)
        {
            pc.printf("In5: 1\n\r"); 
        }
        else
        {
            pc.printf("In5: 0\n\r"); 
        }
    } // if comando ricevuto == ReadGPIO
    else
    {
        // COMANDO PILOTAGGIO OUTPUT: il comando di pilotaggio output è composto da WriteGPIO-abcd
        // a=1/0: accende/spegne il LED di diagnostica LED2
        // b=1/0: Out1 = 1/0
        // c=1/0: Out1 = 1/0
        // d=1/0: Out1 = 1/0
        // verifica se nel comando ricevuto si trova la stringa WriteGPIO
        cCmdPosition=strstr(caRxPacket, "WriteGPIO");
        if(cCmdPosition != NULL) // se il comando ricevuto contiene WriteGPIO, procedi con l'analisi dei dati
        {
            // si posiziona sul delimitatore '-' , tra il comando e i dati ed estrae la stringa contenente lo stato da inviare sugli Output
            cCmdPosition = strtok(caRxPacket,"-"); 
            cCmdPosition = strtok(NULL,"-"); 
            pc.printf("Data: %s\n\r", cCmdPosition); 
                                  
            // USER_LED LED2 se il dato ricevto è '0/1' spegni/accendi il LED
            if(cCmdPosition[0]=='1')
            {
                // accendi LED e comunica al PC
                pc.printf("Led2: ON\n\r"); 
                myLed2 = 1;
            }
            else
            {
                // spegni LED e comunica al PC
                pc.printf("Led2: OFF\n\r"); 
                myLed2 = 0;
            }
            
            // Out1: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[1]=='1')
            {
                // accendi Out1 e comunica al PC
                pc.printf("Out1: ON\n\r"); 
                myOut1 = 1;
            }
            else
            {
                // spegni Out1 e comunica al PC
                pc.printf("Out1: OFF\n\r"); 
                myOut1 = 0;
            }
            
           // Out2: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[2]=='1')
            {
                // accendi Out2 e comunica al PC
                pc.printf("Out2: ON\n\r"); 
                myOut2 = 1;
            }
            else
            {
                // spegni Out2 e comunica al PC
                pc.printf("Out2: OFF\n\r"); 
                myOut2 = 0;
            }
            
            // Out3: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[3]=='1')
            {
                // accendi Out3 e comunica al PC
                pc.printf("Out3: ON\n\r"); 
                myOut3 = 1;
            }
            else
            {
                // spegni Out3 e comunica al PC
                pc.printf("Out3: OFF\n\r"); 
                myOut3 = 0;
            }
        } // if (comando ricevuto contiene "WriteGPIO")
        
        
        // COMANDO DI PILOTAGGIO CANBUS:  Il comando ricevuto per il pilotaggio CANBUS è "CAN-abcd"
        // a=1/0: accende/spegne il LED di diagnostica LED2
        // b=1/0: chiude/apre i relay del connettore 1: Relay11 e Relay12
        // c=1/0: chiude/apre i relay del connettore 2: Relay21 e Relay22
        // d=1/0: chiude/apre i relay del connettore 3: Relay31 e Relay32
        // verifica se nel comando ricevuto è presente la strinca CAN; 
        cCmdPosition=strstr(caRxPacket, "CAN");
        if(cCmdPosition != NULL) // se il comando ricevuto contiene CAN, procedi con l'analisi dei dati
        {
            // si posiziona sul delimitatore '-' , tra il comando e i dati ed estrae la stringa contenente lo stato da inviare sugli Output
            cCmdPosition = strtok(caRxPacket,"-"); 
            cCmdPosition = strtok(NULL,"-"); 
            pc.printf("CAN-Data: %s\n\r", cCmdPosition); 
                                 
            // Resetta: per commutare, apre tutti i relay di commutazione del CANBUS. Negli if() successivi aprirà i canali indirizzati
            myRelayH1 = 0;
            myRelayL1 = 0;                                  
            myNotRelayH2 = 1;                                  
            myNotRelayL2 = 1;                                  
            myNotRelayH3 = 1;                                  
            myRelayL3 = 0;                                  
            
            // USER_LED LED2 se il dato ricevto è '0/1' spegni/accendi il LED
            if(cCmdPosition[0]=='1')
            {
                // Accendi LED e comunica al PC
                pc.printf("Led2: ON\n\r"); 
                myLed2 = 1;
            }
            else
            {
                // spegni LED e comunica al PC
                pc.printf("Led2: OFF\n\r"); 
                myLed2 = 0;
            }
            // CAN1: attiva il CAN sul connettore 1
            if(cCmdPosition[1]=='1') 
            {
                // Chiudi relay del connettore identificato e comunica al PC
                pc.printf("RelayH1: ON\n\r"); 
                pc.printf("RelayL1: ON\n\r"); 
                myRelayH1 = 1;
                myRelayL1 = 1;
                //myTest = 1; // solo per scopi di debug
            }
            else
            {
                // Apri relay del connettore identificato e comunica al PC
                pc.printf("RelayH1: OFF\n\r"); 
                pc.printf("RelayL1: OFF\n\r"); 
                myRelayH1 = 0;
                myRelayL1 = 0;
                //myTest = 0; // solo per scopi di debug
            }
            // CAN2: attiva il CAN sul connettore 2
            if(cCmdPosition[2]=='1') 
            {
                // Chiudi relay del connettore identificato e comunica al PC
                pc.printf("RelayH2: ON\n\r"); 
                pc.printf("RelayL2: ON\n\r"); 
                myNotRelayH2 = 0;
                myNotRelayL2 = 0;
            }
            else
            {
                // Apri relay del connettore identificato e comunica al PC
                pc.printf("RelayH2: OFF\n\r"); 
                pc.printf("RelayL2: OFF\n\r"); 
                myNotRelayH2 = 1;
                myNotRelayL2 = 1;
            }
            // CAN2: attiva il CAN sul connettore 3
            if(cCmdPosition[3]=='1') 
            {
                // Chiudi relay del connettore identificato e comunica al PC
                pc.printf("RelayH3: ON\n\r"); 
                pc.printf("RelayL3: ON\n\r"); 
                myNotRelayH3 = 0;
                myRelayL3 = 1;
            }
            else
            {
                // Apri relay del connettore identificato e comunica al PC
                pc.printf("RelayH3: OFF\n\r"); 
                pc.printf("RelayL3: OFF\n\r"); 
                myNotRelayH3 = 1;
                myRelayL3 = 0;
            }
        }// if (comando ricevuto contiene "CAN")
    }
}

//**********************************************
//          IRQ per la Rx su seriale 
//**********************************************
int main() 
{
    // array per la ricezione dei messaggi da seriale
    //char caRxPacket[PACKETDIM];
    //int nRxPacketSize;
        
    // puntatore al comando, nella stringa ricevuta sulla seriale 
    //char* cCmdPosition;
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    //pc.baud(56000); // 57600 bps
    pc.baud(9600); // 9600 bps
    //pc.baud(19200); // 19200 bps
    //pc.baud(57600); // a questa velocità CVI sulla USB del PC perde dei dati
    //pc.baud(921600); // a questa velocità CVI sulla USB del PC perde dei dati
        
    // inizializza il LED
    myLed1 = 1;
    myLed2 = 1;
    myLed3 = 1;
    wait(1);
    myLed1 = 0;
    myLed2 = 0;
    myLed3 = 0;
    
    // configura il Button come input PullUp. Non premuto = 1, Premuto = 0;
    //+++ myButton.mode(PullUp); //Questo funziona con la F401 
    myButton.mode(PullDown); //Questo funziona con la F207
    
    // configura gli input come PullUp. Aperto = 1;
    myIn1.mode(PullUp);
    myIn2.mode(PullUp);
    myIn3.mode(PullUp);
    myIn4.mode(PullUp);
    myIn5.mode(PullUp);
       
    /********** START Ciclo di test *******
    while(true)
    {
        //if(myButton == 0)
        {
            myLed1 = 1;
            myLed2 = 1;
            myLed3 = 1;
            
            myTest = 0;
            myRelayH1 = 0;
            myRelayL1 = 0;                                  
            myRelayH2 = 0;                                  
            myRelayL2 = 0;                                  
            myRelayH3 = 0;                                  
            myRelayL3 = 0;  
            
                
        }
        //else
        wait (1);
        {
            myLed1 = 0;
            myLed2 = 0;
            myLed3 = 0;    
            
            myTest =1;
            myRelayH1 = 1;
            myRelayL1 = 1;                                  
            myRelayH2 = 1;                                  
            myRelayL2 = 1;                                  
            myRelayH3 = 1;                                  
            myRelayL3 = 1;  
        }
        wait(1);
    }
    ********* END Ciclo di test ********/    
    
    // Attiva la IRQ per la RX su seriale   
    pc.attach(&RxInterrupt,Serial::RxIrq);
    
    // ciclo in cui attende interrupt
    while(true)
    {
    }   
}