// Tested : NUCLEO-F401RE NUCLEO-L476LG
#include "mbed.h"
#include<stdlib.h>

// dimensione del pacchetto di comunicazione tra PC e uC
#define PACKETDIM 64

// comando di Read GPIO
#define READGPIO "Read-GPIO"
// Definizione periferiche
Serial pc(USBTX, USBRX);

// User Button, LED  
DigitalIn myButton(USER_BUTTON);
// Output di servizio sul LED2 della scheda NUCLEO
DigitalOut myLed(LED2);

// Output della NUCLEO e Input del DUT. Saranno inviati dal PC alla NUCLEO, nell'ordine in cui si trovano dichiarati di seguito
DigitalOut myOut1(PA_13);
DigitalOut myOut2(PA_14);
DigitalOut myOut3(PA_15);

// Input della NUCLEO e Output del DUT. Saranno inviati dalla NUCLEO al PC, nell'ordine in cui si trovano dichiarati di seguito
DigitalIn myIn1(PA_8); //PA_8 PC_14
DigitalIn myIn2(PB_10); //PB_10 PC_15
DigitalIn myIn3(PB_4);  //PB_4 PH_0
DigitalIn myIn4(PB_5);  //PB_5 PH_1
DigitalIn myIn5(PB_3);  //PB_3 PD_2
//DigitalIn myService(PB_3);


// indice per i cicli
int nIndex;


// comando ricevuto dal PC attraverso la routine di gestione interrupt Rx
// 1: read all GPIO
// 2: write all GPIO
volatile int nReadCmd=0;

// stato degli input
volatile int myIn1Status;
volatile int myIn2Status;
volatile int myIn3Status;
volatile int myIn4Status;
volatile int myIn5Status;

    

//**********************************************
//          IRQ per la Rx su seriale 
//**********************************************
void RxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char caRxPacket[PACKETDIM];
    int nRxPacketSize;
    
    
    
    // pntatore al comando, nella stringa ricevuta sulla seriale 
    char* cCmdPosition;
    
    // reset array contenente pacchetto ricevuto
    nIndex=0;
    for(nIndex=0;nIndex<PACKETDIM;nIndex++)
    {
        caRxPacket[nIndex]='\0';
    }
        
    // ricevi caratteri su seriale, se disponibili   
    nRxPacketSize =0;
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        pc.scanf("%s", &caRxPacket);
        nRxPacketSize = strlen(caRxPacket);
    }
    // restituisce il comando ricevuto e la dimensione
    pc.printf("Command: %s\n\r",caRxPacket);
    pc.printf("PacketSize: %d\n\r",nRxPacketSize); 
        
    // confronta il comando ricevuto con quello di Read GPIO
    nReadCmd = strcmp(caRxPacket, "ReadGPIO");
    if(nReadCmd==0)
    {
        // rileva lo stato degli input e trasmettili al PC-HOST
        pc.printf("USER-BUTTON: %d\n\r",myButton.read()); // il primo input è lo User-Button per scopi di diagnostica
        // myIn1: se legge 0/1, trasmette lo stato al PC
        if(myIn1==1)
        {
            pc.printf("In1: 1\n\r"); 
        }
        else
        {
            pc.printf("In1: 0\n\r"); 
        }
        
        // myIn2: se legge 0/1, trasmette lo stato al PC
        if(myIn2==1)
        {
            pc.printf("In2: 1\n\r"); 
        }
        else
        {
            pc.printf("In2: 0\n\r"); 
        }
        // myIn3: se legge 0/1, trasmette lo stato al PC
        if(myIn3==1)
        {
            pc.printf("In3: 1\n\r"); 
        }
        else
        {
            pc.printf("In3: 0\n\r"); 
        }
        // myIn4: se legge 0/1, trasmette lo stato al PC
        if(myIn4==1)
        {
            pc.printf("In4: 1\n\r"); 
        }
        else
        {
            pc.printf("In4: 0\n\r"); 
        }
        
        // myIn5: se legge 0/1, trasmette lo stato al PC
        if(myIn5==1)
        {
            pc.printf("In5: 1\n\r"); 
        }
        else
        {
            pc.printf("In5: 0\n\r"); 
        }
    }
    else
    {
        // verifica se nel comando ricevuto si trova la stringa WriteGPIO
        cCmdPosition=strstr(caRxPacket, "WriteGPIO");
        if(cCmdPosition != NULL) // se il comando ricevuto contiene WriteGPIO, procedi con l'analisi dei dati
        {
            // si posiziona sul delimitatore '-' , tra il comando e i dati ed estrae la stringa contenente lo stato da inviare sugli Output
            cCmdPosition = strtok(caRxPacket,"-"); 
            cCmdPosition = strtok(NULL,"-"); 
            pc.printf("Data: %s\n\r", cCmdPosition); 
                                  
            // USER_LED LED2 se il dato ricevto è '0/1' spegni/accendi il LED
            if(cCmdPosition[0]=='1')
            {
                // accendi LED e comunica al PC
                pc.printf("Led2: ON\n\r"); 
                myLed = 1;
            }
            else
            {
                // spegni LED e comunica al PC
                pc.printf("Led2: OFF\n\r"); 
                myLed = 0;
            }
            
            // Out1: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[1]=='1')
            {
                // accendi Out1 e comunica al PC
                pc.printf("Out1: ON\n\r"); 
                myOut1 = 1;
            }
            else
            {
                // spegni Out1 e comunica al PC
                pc.printf("Out1: OFF\n\r"); 
                myOut1 = 0;
            }
            
           // Out2: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[2]=='1')
            {
                // accendi Out2 e comunica al PC
                pc.printf("Out2: ON\n\r"); 
                myOut2 = 1;
            }
            else
            {
                // spegni Out2 e comunica al PC
                pc.printf("Out2: OFF\n\r"); 
                myOut2 = 0;
            }
            
            // Out3: se il dato ricevto è '0/1' spegni/accendi l'output
            if(cCmdPosition[3]=='1')
            {
                // accendi Out3 e comunica al PC
                pc.printf("Out3: ON\n\r"); 
                myOut3 = 1;
            }
            else
            {
                // spegni Out3 e comunica al PC
                pc.printf("Out3: OFF\n\r"); 
                myOut3 = 0;
            }
        }
    }
}

//**********************************************
//          IRQ per la Rx su seriale 
//**********************************************
int main() 
{
    // array per la ricezione dei messaggi da seriale
    char caRxPacket[PACKETDIM];
    int nRxPacketSize;
    
    
    
    // pntatore al comando, nella stringa ricevuta sulla seriale 
    char* cCmdPosition;
    
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    //pc.baud(56000); // 57600 bps
    pc.baud(9600); // 9600 bps
    //pc.baud(19200); // 19200 bps
    //pc.baud(57600); // a questa velocità CVI sulla USB del PC perde dei dati
    //pc.baud(921600); // a questa velocità CVI sulla USB del PC perde dei dati
        
    // inizializza il LED
    myLed = 1;
    wait(1);
    myLed = 0;
    
    // configura il Button come input PullUp. Non premuto = 1, Premuto = 0;
    myButton.mode(PullUp);
    
    // configura gli input come PullUp. Aperto = 1;
    
    myIn1.mode(PullUp);
    myIn2.mode(PullUp);
    myIn3.mode(PullUp);
    myIn4.mode(PullUp);
    myIn5.mode(PullUp);
    
    //myService.mode(PullUp);
    
    // Attiva la IRQ per la RX su seriale   
    pc.attach(&RxInterrupt,Serial::RxIrq);
    /*
    while (true)
    {
        if( (myIn1 == 1) && (myIn2 == 1) && (myIn3 == 1) && (myIn4 == 1) && (myIn5 == 1) )
        {
            myLed = 1;
        }
        else
        {
            myLed = 0;
        }
        pc.printf("Status: %d %d %d %d %d\n\r",myIn1.read(), myIn2.read(), myIn3.read(), myIn4.read(), myIn5.read());
    }
    */
    
    // ciclo in cui attende interrupt
    while(true)
    {
        /*  
        if(pc.readable())
        {
            // reset array contenente pacchetto ricevuto
            nIndex=0;
            for(nIndex=0;nIndex<PACKETDIM;nIndex++)
            {
                caRxPacket[nIndex]='\0';
            }
                
            // ricevi caratteri su seriale, se disponibili   
            nRxPacketSize =0;
            while((pc.readable()))
            {
                // acquisice stringa in input e relativa dimensione
                pc.scanf("%s", &caRxPacket);
                nRxPacketSize = strlen(caRxPacket);
            }
            // restituisce il comando ricevuto e la dimensione
            pc.printf("Command: %s\n\r",caRxPacket);
            pc.printf("PacketSize: %d\n\r",nRxPacketSize); 
                
            // confronta il comando ricevuto con quello di Read GPIO
            nReadCmd = strcmp(caRxPacket, "ReadGPIO");
            if(nReadCmd==0)
            {
                // rileva lo stato degli input e trasmettili al PC-HOST
                pc.printf("USER-BUTTON: %d\n\r",myButton.read()); // il primo input è lo User-Button per scopi di diagnostica
                // myIn1: se legge 0/1, trasmette lo stato al PC
                if(myIn1.read()== 0x01)
                {
                    pc.printf("In1: 1\n\r"); 
                }
                else
                {
                    pc.printf("In1: 0\n\r"); 
                }
                
                // myIn2: se legge 0/1, trasmette lo stato al PC
                if(myIn2.read()== 0x01)
                {
                    pc.printf("In2: 1\n\r"); 
                }
                else
                {
                    pc.printf("In2: 0\n\r"); 
                }
                // myIn3: se legge 0/1, trasmette lo stato al PC
                if(myIn3.read()== 0x01)
                {
                    pc.printf("In3: 1\n\r"); 
                }
                else
                {
                    pc.printf("In3: 0\n\r"); 
                }
                // myIn4: se legge 0/1, trasmette lo stato al PC
                if(myIn4.read()== 0x01)
                {
                    pc.printf("In4: 1\n\r"); 
                }
                else
                {
                    pc.printf("In4: 0\n\r"); 
                }
                
                // myIn5: se legge 0/1, trasmette lo stato al PC
                if(myIn5.read()== 0x01)
                {
                    pc.printf("In5: 1\n\r"); 
                }
                else
                {
                    pc.printf("In5: 0\n\r"); 
                }
            }
            else
            {
                // verifica se nel comando ricevuto si trova la stringa WriteGPIO
                cCmdPosition=strstr(caRxPacket, "WriteGPIO");
                if(cCmdPosition != NULL) // se il comando ricevuto contiene WriteGPIO, procedi con l'analisi dei dati
                {
                    // si posiziona sul delimitatore '-' , tra il comando e i dati ed estrae la stringa contenente lo stato da inviare sugli Output
                    cCmdPosition = strtok(caRxPacket,"-"); 
                    cCmdPosition = strtok(NULL,"-"); 
                    pc.printf("Data: %s\n\r", cCmdPosition); 
                                          
                    // USER_LED LED2 se il dato ricevto è '0/1' spegni/accendi il LED
                    if(cCmdPosition[0]=='1')
                    {
                        // accendi LED e comunica al PC
                        pc.printf("Led2: ON\n\r"); 
                        myLed = 1;
                    }
                    else
                    {
                        // spegni LED e comunica al PC
                        pc.printf("Led2: OFF\n\r"); 
                        myLed = 0;
                    }
                    
                    // Out1: se il dato ricevto è '0/1' spegni/accendi l'output
                    if(cCmdPosition[1]=='1')
                    {
                        // accendi Out1 e comunica al PC
                        pc.printf("Out1: ON\n\r"); 
                        myOut1 = 1;
                    }
                    else
                    {
                        // spegni Out1 e comunica al PC
                        pc.printf("Out1: OFF\n\r"); 
                        myOut1 = 0;
                    }
                    
                   // Out2: se il dato ricevto è '0/1' spegni/accendi l'output
                    if(cCmdPosition[2]=='1')
                    {
                        // accendi Out2 e comunica al PC
                        pc.printf("Out2: ON\n\r"); 
                        myOut2 = 1;
                    }
                    else
                    {
                        // spegni Out2 e comunica al PC
                        pc.printf("Out2: OFF\n\r"); 
                        myOut2 = 0;
                    }
                    
                    // Out3: se il dato ricevto è '0/1' spegni/accendi l'output
                    if(cCmdPosition[3]=='1')
                    {
                        // accendi Out3 e comunica al PC
                        pc.printf("Out3: ON\n\r"); 
                        myOut3 = 1;
                    }
                    else
                    {
                        // spegni Out3 e comunica al PC
                        pc.printf("Out3: OFF\n\r"); 
                        myOut3 = 0;
                    }
                }
            }
        }
        */
    }   
}