// Tested : NUCLEO-F401RE
#include "mbed.h"
#include "AnalogIn.h"

// Input collegato all'ADC
AnalogIn myAnalogIn0(PA_0);
AnalogIn myAnalogIn1(PA_1);
AnalogIn myAnalogIn4(PA_4);
AnalogIn myAnalogIn8(PB_0);
AnalogIn myAnalogIn10(PC_0);
AnalogIn myAnalogIn11(PC_1);
AnalogIn myAnalogIn12(PC_2);


// seriale di collegamento con il PC
Serial pc(SERIAL_TX, SERIAL_RX);

// Output LED di diagnostica
DigitalOut myLed(LED2);


// valore letto dagli ADC
unsigned short usReadADC0; 
unsigned short usReadADC1; 
unsigned short usReadADC4; 
unsigned short usReadADC8; 
unsigned short usReadADC10; 
volatile unsigned short usReadADC11; 
volatile unsigned short usReadADC12; 


 //*******************
 // Loop Principale
 //*******************  
int main()
{
    // carattere ricevuto dal PC su seriale
    char cReadChar ='\0';
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    //pc.baud(56000); //9600 bps
    pc.baud(9600); //9600 bps
    
    
    // ciclo principale
    while(true) 
    {
        if(pc.readable())
        {
            // cattura il carattere ricevuto su seriale
            cReadChar=pc.getc();
            // se carattere ricevuto = 'A' acquisisci da ADC0
            switch(cReadChar)
            {
                case 'A': // ADC0
                {
                    // acquisisce dato dal pin A0 e trasmette al PC
                    usReadADC0 = myAnalogIn0.read_u16();
                    pc.printf("%5d", usReadADC0);
                    //pc.printf("%5d", 32000);
                } break ;
                case 'B': // ADC1
                {
                    // acquisisce dato dal pin A1 e trasmette al PC
                    usReadADC1 = myAnalogIn1.read_u16();
                    pc.printf("%5d", usReadADC1);
                    //pc.printf("%5d", 16000);
                
                } break ;
                case 'C': // ADC4
                {
                    // acquisisce dato dal pin A2 e trasmette al PC
                    usReadADC4 = myAnalogIn4.read_u16();
                    pc.printf("%5d", usReadADC4);
                } break ;
                case 'D': // ADC8
                {
                    // acquisisce dato dal pin A3 e trasmette al PC
                    usReadADC8 = myAnalogIn8.read_u16();
                    pc.printf("%5d", usReadADC8);
                } break ;
                case 'E': // ADC11
                {
                    // acquisisce dato dal pin A4 e trasmette al PC
                    usReadADC11 = myAnalogIn11.read_u16();
                    pc.printf("%5d", usReadADC11);
                } break ;
                case 'F': // ADC10
                {
                    // acquisisce dato dal pin A5 e trasmette al PC
                    usReadADC10 = myAnalogIn10.read_u16();
                    pc.printf("%5d", usReadADC10);
                } break ;
                case 'G': // ADC12
                {
                    // acquisisce dato ADC12 e trasmette al PC
                    usReadADC12 = myAnalogIn12.read_u16();
                    pc.printf("%5d", usReadADC12);
                } break ;
                
                default: 
                {
                } break;
            }
            
            // toggle del LED
            myLed = !myLed;
        }
    
    } // while(true)
}














