/**
 *Verfahren des Schlittens zur Materialförderung
 *
 *CPP-Datei main.cpp
 *
 *@version: 08.09.2015
 *@author: Florian Ungermann & Julian Mueller
 */

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"    
/*Funktionen zum Ansteuern des LCD-Displays (M.Baumeister)*/
#include "TextLCD.h"
/*Funktionen zum Ansteuern der Schrittmotorsteuerung (F.Ungermann)*/ 
#include "SMFunktionen.h"  
/*Funktionen zum Lesen Speichern der Parameter (J. Müller)*/
#include "SpeicherFunktionen.h" 
/*Ausgelagerte Beschleunigungsfunktion und Variablen*/
#include "Beschleunigungsfunktion.h"
/*Ausgelagerte Bremsfunktion*/
#include "Bremsfunktion.h"
/*Ausgelagerte Entstörfunktion*/
#include "EntstoerFunktion.h"

/*Erstellung des local file systems, um Parameter einlesen zu können*/
LocalFileSystem local("local");

/*Mikrocontroller Eingänge*/
DigitalIn schalter1(p5); //Schalter links
DigitalIn schalter2(p6); //Schalter mitte
DigitalIn schalter3(p7); //Schalter rechts

/*SPS Ein- und Ausgänge*/
DigitalIn sps_ein1(p14);  //eingehendes Signal 1 von SPS
DigitalIn sps_ein2(p15);  //eingehendes Signal 2 von SPS
DigitalOut sps_aus1(p16); //ausgehendes Signal 1 an SPS
DigitalOut sps_aus2(p17); //ausgehendes Signal 2 an SPS

/*Mikrocontroller Ausgänge*/
TextLCD lcd(p24, p25, p26, p27, p28, p29); //LCD Display 2x16

/*Timer*/
Timer debounce1;    //Timer zum Entprellen von Schalter links
Timer debounce2;    //Timer zum Entprellen von Schalter mitte
Timer debounce3;    //Timer zum Entprellen von Schalter rechts
Timer antiflimmer;  //Timer gegen Displayflimmern
Timer spsE1;        //Timer für Impulserkennung sps_ein1
Timer spsE2;        //Timer für Impulserkennung sps_ein2

//Ausschließlich für Beschleunigung im Tippbetrieb
int bStrecke;

/*Variablen für Softanlauf Handbetrieb*/
int anlauf_links = 0;   //=1 wenn Anlauf in Drehrichtung links vollständig durchgeführt wurde
int anlauf_rechts = 0;  //=1 wenn Anlauf in Drehrichtung rechts vollständig durchgeführt wurde

/*Geschwindigkeitsvariablen vorgeben*/
int geschwaktuell; 
//REFERENZFAHRT
int rstufen = 10; //Anzahl Stufen der Beschleunigungsfunktion REFERENZFAHRT
int rschrps = 50; //Anzahl Schritte pro Stufe der Beschleunigungsfunktion REFERENZFAHRT

/*allgemeine Festsetzug der Intervallgrenzen für die SPS-Signale der Ref-Fahrt und des Auto-Betriebes in [ms]*/
int obergrenze = 200;
int untergrenze = 5;
    
int main(){
    /* Parameter aus der setup.txt einlesen*/
    ReadFile();
    
    /*Timer für Schalterentprellung starten*/
    debounce1.start();
    debounce2.start();
    debounce3.start();
    /*Timer gegen Displayflimmern starten*/
    antiflimmer.start();
    
    /*Motor einschalten, damit er nicht stromlos ist*/
    SM_Einschaltzustand_Setzen(1);
    
    /*Sperren der MOSFETS, am SI-1 und SI-2 liegen 24V an*/
    sps_aus1 = 0;
    sps_aus2 = 0;
    
    /*Zustand Referenzfahrt*/
    /*Erkennung (Timer) initialisieren*/
    /*Zählt Anzahl zulässiger Impulse*/
    int impulsE1 = 0;
    int impulsE2 = 0;
        
    /*Zeigt an ob Timer läuft oder nicht*/
    int timerE1 = 0;
    int timerE2 = 0;
        
    /*Timer zurücksetzen*/
    spsE1.stop();
    spsE1.reset();
    spsE2.stop();
    spsE2.reset();
    /*Ende der Initialisierung*/
    
    while(1){
        bool spsReferenzfahrt = false;
        
        /*Displayausgabe*/
        if(impulsE1 == 0){
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Referenzfahrt ? ");
        }
        
        /*Drehrichtung setzen*/
        SM_Drehrichtung_Setzen(0);
        
        /*Ekennungs-Funktion zur Referenzfahrt via SPS*/
        /*Hochzaehlfunktionen der SPS-Signale Format: 8:1*/
        if(sps_ein1==1 && timerE1==0){
            spsE1.start();
            timerE1=1;
        }
            
            /*Impuls-Hochzähler*/
            else if(sps_ein1==0 && timerE1==1){
                spsE1.stop();
                timerE1=0;
                if(spsE1.read_ms()<obergrenze && spsE1.read_ms()>untergrenze){
                    impulsE1 = impulsE1 + 1;
                }
                if(impulsE1 > 8){
                    impulsE1 = 0;
                }
                spsE1.reset();
            }
      
        if(sps_ein2==1 && timerE2==0 && impulsE1 > 0){
            spsE2.start();
            timerE2=1;
        }
            
            else if(sps_ein2==0 && timerE2==1){
                spsE2.stop();
                timerE2=0;
                if(spsE2.read_ms()<obergrenze && spsE2.read_ms()>untergrenze && impulsE1 == 8){
                    impulsE2 = 1;
                }
                spsE2.reset();
            } 
            
        if(impulsE1==8 && impulsE2==1){ 
            spsReferenzfahrt = true; 
            lcd.cls();
            lcd.printf("SPS ausgel.. Referenzfahrt");    
        }
        
        /*Referenzfahrt-Routine*/
        /*Durch Drücken von Schalter links ODER beim richtigen SPS-Signal wird Referenzfahrt durchgeführt.*/
        if(spsReferenzfahrt || schalter1 == 1){
            int refStrecke = 1000;
            /*Wenn der Schlitten schon ganz hinten steht, dann gehe 1000 Schritte vor und führe dann die Referenzfahrt aus*/
            if(reftaster){
                /*Drehrichtung vom Schalter weg setzen*/
                SM_Drehrichtung_Setzen(1);
                /*Beschleunigen*/  
            /*for-Schleife für Anzahl Stufen*/
            for(int i=0;i<rstufen && refStrecke>=0;i=i+1){
                geschwaktuell = geschwaktuell + (gref/rstufen); 
                /*for-Schleife für Anzahl Schritte pro Stufe*/
                for(int j=0;j<rschrps && refStrecke>=0;j=j+1){
                    SM_Impuls_Setzen(geschwaktuell);
                    refStrecke--;   
                }
            }
            /*Fahre so lange vom Schalter weg, bis die 1000 Schritte erreicht sind, dann kehre um.*/
            while(refStrecke >= 0){
                refStrecke--;
                SM_Impuls_Setzen(geschwaktuell);
                }
        }
            
            /*Beschleunigen & Drehrichtung sicher in Referenzrichtung setzen*/
            SM_Drehrichtung_Setzen(0);
            /*for-Schleife für Anzahl Stufen*/
            for(int i=0;i<rstufen && refEntstoert(reftaster)==0;i=i+1){
                geschwaktuell = geschwaktuell + (gref/rstufen); 
                /*for-Schleife für Anzahl Schritte pro Stufe*/
                for(int j=0;j<rschrps && refEntstoert(reftaster)==0;j=j+1){
                    SM_Impuls_Setzen(geschwaktuell);
                    
                }
            }
            /*So lange der Reftaster null ist, nach hinten fahren*/    
            while(refEntstoert(reftaster) == 0){
                SM_Impuls_Setzen(geschwaktuell);
            }
            
            /*Position gleich Null setzen*/
            position = 0;   
            
            /*Zustand Referenzfahrt verlassen*/
            break;
        }
    }
    
    /*Beginn Zustandsautomat*/
    while(1){
        /*Zustand Tippbetrieb*/
        /*Initialisierung aller Hilfsvariablen zur Erkennung von SPS-Signalen*/
        /*Zählt Anzahl zulässiger Impulse*/
        impulsE1 = 0;
        impulsE2 = 0;
        
        /*Zeigt an ob Timer läuft oder nicht*/
        timerE1 = 0;
        timerE2 = 0;
        
        /*Timer zurücksetzen*/
        spsE1.stop();
        spsE1.reset();
        spsE2.stop();
        spsE2.reset();
        
        /*Ende der Initialisierung der Hilfsvariablen für die SPS*/
        while(1){    
            /*Initialisierung zur Erkennung von SPS Signalen*/
            /*Wird erst zu logischen 1, wenn das SPS-Signal*/
            bool spsTippVerlassen = false;
        
        /*Ekennungs-Funktion zur Referenzfahrt via SPS*/
        /*Hochzaehlfunktionen der SPS-Signale Format: 9:1*/
        if(sps_ein1==1 && timerE1==0){
            spsE1.start();
            timerE1=1;
        }
        
            /*Impuls-Hochzähler*/
            else if(sps_ein1==0 && timerE1==1){
                spsE1.stop();
                timerE1=0;
                if(spsE1.read_ms()<obergrenze && spsE1.read_ms()>untergrenze){
                    impulsE1 = impulsE1 + 1;
                }
                if(impulsE1 > 9){
                    impulsE1 = 0;
                }
                spsE1.reset();
            }
      
            if(sps_ein2==1 && timerE2==0 && impulsE1 > 0){
                spsE2.start();
                timerE2=1;
            }
            
                else if(sps_ein2==0 && timerE2==1){
                    spsE2.stop();
                    timerE2=0;
                    if(spsE2.read_ms()<obergrenze && spsE2.read_ms()>untergrenze && impulsE1 == 9){
                        impulsE2 = 1;
                    }
                    spsE2.reset();
                } 
            
            if(impulsE1==9 && impulsE2==1){ 
                spsTippVerlassen = true; 
                impulsE2=0;
                impulsE1=0;
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("SPS ausgel.. Autobetrieb"); 
            }
        
        /*Ende Routine zum Erkennen von SPS-Signalen*/
        /*Display: aktuelle Position ausgeben.*/
        lcd.locate(0,0);
        lcd.printf("Tipp: %i          ", position);
            
        /*Wenn Schalter links gedrückt, Schlitten beschleunigen*/
        if(schalter1 == 1){
            /*Neuinitialisierungen nötig.*/
            bStrecke = 300; 
            bStufe = 0; 
            bZaehlerUp=0;
            bGesch = gtipp/anzStufenTipp; 
            SM_Drehrichtung_Setzen(0);
            for(int i=0;i<anzStufenTipp;i++){
                bZaehlerUp = 0;
                //Stufenlänge berechnen
                bStufe = bStrecke - (bStrecke/1.1);
                    while(bStufe>=bZaehlerUp && schalter1==1){
                        SM_Impuls_Setzen(bGesch);
                        position--;
                        bStrecke--;
                        bZaehlerUp++;
                    }
                    
                /*Geschwindigkeit erhöhen*/
                bGesch = bGesch + (gtipp/anzStufenTipp);
                /*Verbleibende Beschleunigungsstrecke ausrechnen*/
                //bStrecke = bStrecke - bStufe;
            }
                while(schalter1==1){
                    SM_Impuls_Setzen(gtipp);
                    position--;
                }
            }
                    
            /*Wenn Schalter mitte gedrückt, Schlitten beschleunigen*/
            else if(schalter2 == 1){
                /*Neuinitialisierungen nötig.*/
                bStrecke = 300; 
                bStufe = 0; 
                bGesch = gtipp/anzStufenTipp; 
                SM_Drehrichtung_Setzen(1);
                    for(int i=0;i<anzStufenTipp;i++){
                        bZaehlerUp = 0;
                        //Stufenlänge berechnen
                        bStufe = bStrecke - (bStrecke/1.1);
                            while(bStufe>=bZaehlerUp && schalter2==1){
                                SM_Impuls_Setzen(bGesch);
                                position++;
                                bStrecke--;
                                bZaehlerUp++;
                            }
                        /*Geschwindigkeit erhöhen*/
                        bGesch = bGesch + (gtipp/anzStufenTipp);
                        /*Verbleibende Beschleunigungsstrecke ausrechnen*/
                        //bStrecke = bStrecke - bStufe;
                        }
                        while(schalter2==1){
                            SM_Impuls_Setzen(gtipp);
                            position++;
                        }
                    }
                    
                /*Bearbeitet durch Julian am 07.12.2015, erweitert um SPS-Funktion:*/
                /*Durch Drücken von Schalter rechts ODER SPS-Signal: Zustand Tippbetrieb verlassen.
                Zur Schalterentprellung wird der Timer geprüft*/
                else if((schalter3 == 1 && debounce3.read_ms()>500)|| spsTippVerlassen){
                    /*Display: Reset*/
                    lcd.cls();
                    /*Timer für Schalterentprellung zurücksetzen*/
                    debounce3.reset();
                    /*Zustand Handbetrieb verlassen, weiter im Automatikbetrieb*/
                    break;
                    }
        }
        
        /*Hier wird das Programm fortgesetzt, wenn Zustand Tippbetrieb verlassen wurde*/
        /*Start Übergangsroutine zwischen Tipp- und Automatikbetrieb*/
        
        /*Zustand als 0 definieren*/
        //int zustand = 0;
        
        /*Zählt Anzahl zulässiger Impulse*/
        impulsE1 = 0;
        impulsE2 = 0;
        
        /*Zeigt an ob Timer läuft oder nicht*/
        timerE1 = 0;
        timerE2 = 0;
        
        /*Timer zurücksetzen*/
        spsE1.stop();
        spsE1.reset();
        spsE2.stop();
        spsE2.reset();
        
        /*Ende Übergangsroutine zwischen Tipp- und Automatikbetrieb*/
        
        /*Zustand Automatikbetrieb*/
        while(1){   
            if(sps_ein1==1 && timerE1==0){
                spsE1.start();
                timerE1=1;
            }
            
            else if(sps_ein1==0 && timerE1==1){
                    spsE1.stop();
                    timerE1=0;
                        if(spsE1.read_ms()<obergrenze && spsE1.read_ms()>untergrenze){
                            impulsE1++;
                            spsE1.reset();
                        }    
                      else{
                            if(impulsE1 > 4){
                            impulsE1 = 0;
                            impulsE2 = 0;
                        }
                    spsE1.reset();
                    }
                }
      
                if(sps_ein2==1 && timerE2==0 && impulsE1 > 0){
                    spsE2.start();
                    timerE2=1;
                }
                    else if(sps_ein2==0 && timerE2==1){
                            spsE2.stop();
                            timerE2=0;
                                if(spsE2.read_ms()<obergrenze && spsE2.read_ms()>untergrenze && impulsE1 > 0){
                                    impulsE2++;
                                    spsE2.reset();
                                }
                              else{ if(impulsE2 >= 1){
                                    impulsE1 = 0;
                                    impulsE2 = 0;
                                }
                            spsE2.reset();    
                            }
                        } 
            
                if(impulsE2==1 && impulsE1==1){
                    impulsE2=0;
                    impulsE1=0;
                    /*Fahre zum Separator*/
                    /*Beschleunigen und Fahren*/
                    beschleunigungAuto(anzStufen, posse, bZeit_MS);
                    /*Abbremsen und Ziel erreichen*/
                    bremsung(anzAStufen);
                }
            
                if(impulsE2==1 && impulsE1==2){
                    impulsE2=0;
                    impulsE1=0;
                    /*Fahre zur Anode*/
                    /*Beschleunige und Fahren*/
                    beschleunigungAuto(anzStufen, posan, bZeit_MS);
                    /*Abbremsen und Ziel erreichen*/
                    bremsung(anzAStufen);
                }
                
                if(impulsE2==1 && impulsE1==3){
                    impulsE2=0;
                    impulsE1=0;
                    /*Fahre zur Kathode*/
                    /*Beschleunigen und Fahren*/
                    beschleunigungAuto(anzStufen, poskat, bZeit_MS);
                    /*Abbremsen und Ziel erreichen*/
                    bremsung(anzAStufen);
                }
                
                if(impulsE2==1 && impulsE1==4){
                    impulsE2=0;
                    impulsE1=0;
                    /*Fahre zum Auswurf*/
                    /*Beschleunigen und Ziel erreichen*/
                    beschleunigungAuto(anzStufen, 0, bZeit_MS);
                    /*Abbremsen und Ziel erreichen*/
                    bremsung(anzAStufen); 
                    position==0;       
                } 
                        
                /*Durch Drücken von Schalter rechts Automatikbetrieb verlassen. Zur Schalterentprellung wird der Timer geprüft*/
                if(schalter3==1 && debounce3.read_ms()>500){
                /*Timer für Schalterentprellung zurücksetzen*/
                debounce3.reset();
                /*Zustand Automatikbetrieb verlassen, weiter im Handbetrieb*/
                break;
                }
            }
        }     
    }