/**
 *Funktionen zum Speichern der Verfahrparameter.
 *
 *CPP-Datei: SpeicherFunktionen.cpp
 *
 *@version: 08.09.2016
 *@author: Julian Mueller
 */
 
#include "SpeicherFunktionen.h"

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

/*Variablen*/
int posan;  //Position der Anode
int poskat; //Position der Kathode
int posse;  //Position des Seperators
int anzStufen; //Unterteilung der Beschleunigungsstecke in Stufen AUTObetrieb
int anzAStufen; //Unterteilung der Abbremsstrecke in Stufen im AUTObetrieb
int anzStufenTipp; //Unterteilung der Beschleunigungsstrecke in Stufen TIPPbetrieb
int bZeit_MS; //Zeit, welche die Beschleunigungsrampe dauert
int aZeit_MS; // Zeit, welche die Bremsrampe dauert
int gref; //Geschwindigkeit (in Schritten/Sekunde) für Referenzfahrt
int gtipp; //Geschwindigkeit (in Schritten/Sekunde) für Tippbetrieb
int gauto; //Geschwindigkeit (in Schritten/Sekunde) für Autobetrieb
char A[20],B[20],C[20],D[20],E[20],F[20], G[20], H[20], I[20], J[20], K[20];

void ReadFile (void) {
    FILE *set = fopen("/local/setup.txt", "r");  //Öffnet "setup.txt" auf dem local file system zum lesen
    fscanf(set,"%s %i",A,&posan);  //liest Anodenposition
    fscanf(set,"%s %i",B,&poskat);  //liest Kathodenposition
    fscanf(set,"%s %i",C,&posse);  //liest Separatorposition
    fscanf(set,"%s %i",D,&anzStufen); //liest Beschleunigungsstufenanzahl im Autobetrieb
    fscanf(set,"%s %i",E,&anzAStufen); //liest Abbremsstufenanzahl
    fscanf(set,"%s %i",F,&anzStufenTipp); //liest Beschleunigungsstufenanzahl im Tippbetrieb
    fscanf(set,"%s %i",G,&bZeit_MS); //Zeit, die eine Beschleunigungsrampe dauern soll
    fscanf(set,"%s %i",H,&aZeit_MS); //liest Länge der grossen Beschleunigungsstrecke (alle anderen)
    fscanf(set,"%s %i",I,&gref); //liest Geschwindigkeit der Referenzfahrt
    fscanf(set,"%s %i",J,&gtipp); //liest Geschwindigkeit des Tippbetriebs
    fscanf(set,"%s %i",K,&gauto); //liest Geschwindigkeit des Autobetriebs
    fclose(set);
}

void WriteFile(void) {
    FILE *fp = fopen("/local/setup.txt", "w");  //Öffnet "setup.txt" auf dem local file system zum schreiben
    /*Falls mal benötigt: Hier die Funktionalität für schreibende Funktionen implementieren*/
    fclose(fp);
}