/**
 *Funktionen zum Speichern der Verfahrparameter.
 *
 *Header-Datei: SpeicherFunktionen.h
 *
 *@version: 08.09.2016
 *@author: Julian Mueller
 */
 
#ifndef SPEICHERFUNKTIONEN_H
#define SPEICHERFUNKTIONEN_H

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

/**
 * Funktion zum Lesen der in setup.txt (USB Speicher) gespeicherten Werte
 */
void ReadFile(void);

/**
* Funktion zum Speichern der Verfahrparameter in setup.txt (USB Speicher)
*/
void WriteFile(void);

/*Variablen*/
extern int posan;  //Position der Anode
extern int poskat; //Position der Kathode
extern int posse;  //Position des Seperators
extern int anzStufen; //Unterteilung der Beschleunigungsstecke in Stufen AUTObetrieb
extern int anzAStufen; //Unterteilung der Abbremsstrecke in Stufen im AUTObetrieb
extern int anzStufenTipp; //Unterteilung der Beschleunigungsstrecke in Stufen TIPPbetrieb
extern int bZeit_MS; //Zeit, welche die Beschleunigungsrampe dauert
extern int aZeit_MS; // Zeit, welche die Bremsrampe dauert
extern int gref; //Geschwindigkeit (in Schritten/Sekunde) für Referenzfahrt
extern int gtipp; //Geschwindigkeit (in Schritten/Sekunde) für Tippbetrieb
extern int gauto; //Geschwindigkeit (in Schritten/Sekunde) für Autobetrieb

#endif 