/**
 *Funktionen zum Ansteuern der Schrittmotorsteuerung.
 *Schrittmotorsteuerung: SainSmart ST330.
 *Schrittmotor: Trinamic QMot QSH5718-51-28-101.
 *
 *Headerdatei: SMFunktionen.h
 *
 *@version: 08.09.2015 (keine PWM)
 *@author: Florian Ungermann
 */
 
#ifndef SMFUNKTIONEN_H
#define SMFUNKTIONEN_H

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

/**
 * Funktion zum Setzen des Einschaltzustandes des Schrittmotors.
 * @param einschaltzustand: 0 = aus, 1 = an
 */
void SM_Einschaltzustand_Setzen(int einschaltzustand);

/**
 * Funktion zum Setzen der Drehrichtung des Schrittmotors.
 * @param drehrichtung: 0 = gegen Uhrzeigersinn, 1 = im Uhrzeigersinn
 */
void SM_Drehrichtung_Setzen(int drehrichtung);

/**
 * Funktion zum setzen eines Impulses. 
 * es liegt so lange eine logische 1 an, dass bei wiederholtem Durchlaufen der Funktion
 * sm_schritte pro Sekunde ausgeführt werden
 * @param sm_schritte: Schritte pro Sekunde
 */
void SM_Impuls_Setzen(float sm_schritte);

/*Ausgänge Mikrocontroller*/
extern DigitalOut sm_einschaltzustand;  //Digital Ausgang: EN
extern DigitalOut sm_drehrichtung;      //Digital Ausgang: DIR
extern DigitalOut sm_impuls;            //Digital-Ausgang: STEP

#endif