/**
 *Funktionen zum Ansteuern der Schrittmotorsteuerung.
 *Schrittmotorsteuerung: SainSmart ST330.
 *Schrittmotor: Trinamic QMot QSH5718-51-28-101.
 *
 *CPP-Datei: SMFunktionen.cpp
 *
 *@version: 08.09.2015 (keine PWM)
 *@author: Florian Ungermann 
 */
 
#include "SMFunktionen.h"

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

/*Ausgänge Mikrocontroller*/
DigitalOut sm_einschaltzustand(p21); //Digitaler Ausgang: EN
DigitalOut sm_drehrichtung(p22);     //Digitaler Ausgang: DIR
DigitalOut sm_impuls(p23);           //Digitaler Ausgang: STEP

void SM_Einschaltzustand_Setzen(int einschaltzustand){
    /*Einschaltzustand setzen.
    1 = Motor wird mit Strom versorgt.
    0 = Motor ist stromlos.*/
    sm_einschaltzustand = einschaltzustand;
}
    
void SM_Drehrichtung_Setzen(int drehrichtung){
    /*Drehrichtung setzen.
    1 = im Uhrzeigersinn (abwickeln).
    0 = gegen den Uhrzeigersinn (aufwickeln)*/
    sm_drehrichtung = drehrichtung;
}    

void SM_Impuls_Setzen(float sm_schritte){
    /*Impuls setzen.
    es liegt so lange eine logische 1 an, dass bei wiederholtem Durchlaufen der Funktion
    sm_schritte pro Sekunde ausgeführt werden*/
    sm_impuls = 1;
    wait((1/sm_schritte)/2);
    sm_impuls = 0;
    wait((1/sm_schritte)/2);
}