/**
 *Funktionen zum Ansteuern der Schrittmotorsteuerung.
 *Schrittmotorsteuerung: SainSmart ST330.
 *Schrittmotor: Trinamic QMot QSH5718-51-28-101.
 *
 *Headerdatei: BESCHLEUNIGUNGSFUNKTION.h
 *
 *@version: 22.10.2016 
 *@author: Julian Mueller
 */
 
#ifndef BESCHLEUNIGUNGSFUNKTION_H
#define BESCHLEUNIGUNGSFUNKTION_H

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

/**
 * Funktion zum Beschleunigen
 * @param TODO
 */
void beschleunigungAuto(int anzahlStufen, int zielposition, int millisekunden);

/*Initialisierung und Belegung von Variablen, die in der Beschleunigung benötigt werden*/    
//extern int anzStufen = 110; //Unterteilung der Beschleunigungsstecke in Stufen AUTObetrieb
//extern int anzStufenTipp = 20; //Unterteilung der Beschleunigungsstrecke in Stufen TIPPbetrieb
extern float bZaehlerUp; //Zählvariable, die die in einer Stufe zurückgelegten Schritte mitzählt
extern int bGesch; //Geschwindigkeit in einer bestimmten Beschleunigungsstufe
extern int bStufe; //Länge (in Schritten) die eine Beschleunigungsstufe dauert
extern int streckeTotal; //Merkvariable, die die zu fahrende Absolutstrecke zwischen zwei Positionen berechnet
extern int vmax; // Geschwindigkeit zur Kathode, in Abhängigkeit davon, ob vom Ref-Punkt oder von einer anderen Position angefahren wird 
               
/*Initialisierung und Belegung von Variablen, die in der Abbremsung benötigt werden*/                
//extern int anzAStufen = 30; //Unterteilung der Abbremsstrecke in diese Stufen
extern int aStrecke;  //Aktuell verbleibende Strecke zum Bremsen
extern int aStufe; //Aktuelle (verbleibende) Länge der gerade durchlaufenen Stufe
extern int aGesch; // Aktuelle Geschwindigkeit in Schritten pro Sekunde
extern int aZaehlerUp; // Zähler, der die innerhalb einer Stufe bereits durchlaufenen Schritte mitzählt

extern int strecke;
extern int richtung;
extern int position; //aktuelle Position in Inkrementen

#endif