/**
 *Funktionen zum Ansteuern der Schrittmotorsteuerung.
 *Schrittmotorsteuerung: SainSmart ST330.
 *Schrittmotor: Trinamic QMot QSH5718-51-28-101.
 *
 *CPP-Datei: SMFunktionen.cpp
 *
 *@version: 08.09.2015 (keine PWM)
 *@author: Florian Ungermann & Julian Mueller
 */
 
#include "Beschleunigungsfunktion.h"

/*offizielles mbed C/C++ SDK (mbed.org)*/
#include "mbed.h"

#include "SMFunktionen.h"
#include "SpeicherFunktionen.h"

Timer bZeit;

//Einmalige Definition der Variablen. Durch gegenseitige Einbindung der Header nur einmal hier nötig.
float bZaehlerUp;
int bGesch;
int bStufe;
int streckeTotal;
int vmax;
int aStrecke;
int aStufe;
int aGesch; // Aktuelle Geschwindigkeit in Schritten pro Sekunde
int aZaehlerUp; // Zähler, der die innerhalb einer Stufe bereits durchlaufenen Schritte mitzählt
int strecke;
int richtung;
int position; //aktuelle Position in Inkrementen

void beschleunigungAuto(int anzahlStufen, int zielposition, int millisekunden){
    bZeit.stop();
    bZeit.reset();
    
    /*Distanz berechnen*/
                bStufe = 0;
                vmax = 0;  
                strecke = 0; 
                streckeTotal = 0;
                strecke = zielposition - position;
                if(strecke > 0){
                    SM_Drehrichtung_Setzen(1);
                    richtung = 1;
                }
                else if(strecke < 0){
                    SM_Drehrichtung_Setzen(0);
                    richtung = 0;
                }
                strecke = abs(strecke);
                
                streckeTotal = strecke;
                
                /*Unterscheide, ob vom Refschalter auf die Kathode gefahren wird oder nicht*/
                if(streckeTotal==poskat || zielposition == 0){
                vmax = gtipp;
                }
                else if(streckeTotal>poskat){
                    vmax = gauto;
                    }
                
                //Geschwindigkeit, die in einer bestimmten Beschleunigungsstufe gefahren wird.
                //Starte mit der Basisstufe: vmax/anzahlStufen    
                bGesch = vmax/anzahlStufen; 
                
                
                //Stufenlänge in Millisekunden bei linearer Beschleunigung:
                bStufe = millisekunden/anzahlStufen;
        
        
        for(int i = 1; i<=anzahlStufen; i++){
                bZeit.start();               
                        while(bZeit.read_ms()<=bStufe){
                            
                            SM_Impuls_Setzen(bGesch);
                            if(richtung==1){
                            position++;
                             }
                            else if(richtung==0){
                                position--;
                                 }
                                 strecke--;
                            } // end WHILE
                            
                            bZeit.stop();
                            bZeit.reset();
                            
                            /*Geschwindigkeit inkrementieren*/
                            bGesch += (vmax/anzahlStufen);
                            } // end FOR, alle Stufen abgearbeitet
                            
                            
                        //Fahre so lange geradeaus, bis nur noch i% der Fahrtstrecke verbleiben
                        //Fahrt mit vmax
                      while(strecke>2500){
                          SM_Impuls_Setzen(vmax);
                          if(richtung==1){
                            position++;
                             }
                            else if(richtung==0){
                                position--;
                                 }
                          strecke--;      
                } // end WHILE
    
}