#include "mbed.h"
#define N 100


// TEST DI GENERAZIONE SEGNALE AUDIO ANALOGICO

// Definizione Seriale di comunicazione con PC
Serial pc(USBTX, USBRX, 921600);

//Pin di uscita del segnale Audio
AnalogOut aAudioOut(PA_5);
//DigitalOut dAudioOut (D13); // scopi diagnostici

// periferiche presenti On Board 
DigitalOut OnBoardRedLED (LED3);
DigitalOut OnBoardGreenLED (LED1);
DigitalOut OnBoardBlueLED (LED2);
DigitalIn OnBoardButton (USER_BUTTON);
Ticker mySoundGeneration;

 

    //Dichiarazione variabioi volatili e globali
    volatile bool bStop;
    volatile int i = 0;
    double y;
    char cRxChar;
    volatile double afSin[N]; 
    
    //Funzione che inserisce nell'array 'afSin' la sinusoide generata
    void sineGeneration()
    {
        for(int j = 0;j<N;j++)
        {
            afSin[j]=(sin((6.28/N)*j)+1)/2.0;
        
        }
    
    }
    
    //Funzione la quale riproduce la sinusoide precedentemente messa nell'array 'afSin'
    void soundGeneration()
    {  

      //pc.printf("Sono qui = 3\r\n");              //Necessità diagnostiche
        if(bStop==0)                              //Condizione necessaria per l'utilizzo di hyperterminal, nel caso si voglia fermare o far riprendere la produzione di frequenze
        {   
            aAudioOut.write(afSin[i]);
            i++;
            if(i >=N)
            {
                 i = 0;
            }
            
        } 
    
    }

    void cambiaFrequenza(double _fs){
        double _Ts, _T;
        _Ts= 1/_fs;
        _T=_Ts/N;
        
        mySoundGeneration.detach();
        mySoundGeneration.attach(&soundGeneration, _T);
    
    }    

    
/********************/
/*      Main        */
/********************/


 
int main()
{

    //  messaggio di benvenuto
    pc.printf("Welcome to Tesys-Rail\r\n");
    
    //inizializza variabili necessarie per l'utilizzo della seriale
    bStop=0;
    cRxChar = 0;
    
    // ACCENSIONE led DI BENVENUTO
    OnBoardRedLED=1;
    OnBoardBlueLED=1;
    OnBoardGreenLED=1;
    wait(2);
    OnBoardRedLED=0;
    OnBoardBlueLED=0;
    OnBoardGreenLED=0;
     
     //Dichiarazione variabili
    double fs = 40.0;
    volatile double Ts = 1.0/fs;
    volatile double T = Ts/N;
    //printf("T = %.6f\r\n", T); //Necessità diagnostiche
   
    //  Agganciamento Ticker alla funzione soundGeneration
    sineGeneration();
    mySoundGeneration.attach(&soundGeneration, T);

     
     

        
    //++++++++++++++++++ INIZIO Test generazione Audio con segnale Analogico +++++++++++++++++++++ */
        
        /********************/
        /* Ciclo Principale */
        /********************/
        while(true)
        {
            //Inizio condizione per far fermare o riprendere l'esecuzione della funzione soundGeneration
                

                
                if(pc.readable())
                {
                    //pc.printf("Sono qui = 0\r\n");  //Necessità diagnostiche
        
                    cRxChar = pc.getc(); 
                    //+++++++++++++++++++++++++++++++++++++++++++++++
                    //Opzioni di cambio frequenza da seriale
                    switch(cRxChar)
                    {
                        case '1':
                            cambiaFrequenza(40.0);
                            pc.printf("\r\n");
                        break;
                        
                        case '2':
                            cambiaFrequenza(80.0);
                            pc.printf("\r\n");
                        break;
                        
                        case '3':
                            cambiaFrequenza(130.0);
                            pc.printf("\r\n");
                        break;
                        
                        case '4':
                            cambiaFrequenza(180.0);
                            pc.printf("\r\n");
                        break;
                        
                        case '5':
                            cambiaFrequenza(240.0);
                            pc.printf("\r\n");
                        break;
                        
                        case '6':
                            cambiaFrequenza(300.0);
                            pc.printf("\r\n");
                        break;
                        
                         case 's':
                            bStop = 1;
                            pc.printf("\r\n");
                        break;
                        
                        case 'r':
                            bStop = 0;
                            pc.printf("\r\n");
                        break;
                        
                        case 'c':
                            pc.printf("\033[2J");
                            pc.printf("\r");
                        break;
                         
                        default: 
                            pc.printf("\r\n");
                        break;                                                                            
                    
                    }
                   //+++++++++++++++++++++++++++++++++++++++++++++++
                    
                }
                
            }  
            /********************/
            /*      Fine        */             
            /* Ciclo Principale */
            /********************/
            
        }
        
        /********************/
        /*      Fine        */
        /*       Main       */
        /********************/
        
        



    
    

        
        
    
    //++++++++++++++++++ FINE Test generazione Audio con segnale Analogico +++++++++++++++++++++

    //++++++++++++++++++ INIZIO Test generazione Audio con segnale digitale +++++++++++++++++++++
    /*
    while(true)
    {
        dAudioOut = 1;
        wait_us(1270); // semiperiodo del segnale da generare (Sol 392Hz)
        dAudioOut = 0;
        wait_us(1270); // semiperiodo del segnale da generare
    }
    */
    //++++++++++++++++++ FINE Test generazione Audio con segnale digitale ++++++++++++++++++++++++

