#include "mbed.h"
#include "TYPE_Def.h"
#include "CRC32BIT_LOOKUP_Ext.h"

Serial pc(USBTX, USBRX); // tx, rx
BusIn port0(PA_12,PA_9,PA_8,PA_7,PA_6,PA_4,PA_1,PA_0);
BusIn port1(PB_10,PB_7,PB_6,PB_5,PB_4,PB_3,PB_1,PB_0);
BusIn port2(PC_8,PC_7,PC_6,PC_5,PC_3,PC_2,PC_1,PC_0);
BusIn port3(PC_4,PB_12,PA_11,PC_15,PC_14,PA_15,PA_14,PA_13);

UINT32_T crc;
ERROR_T ERROR_Value;
CRC32BIT_LOOKUP_TS _Crc32Table_TGP_DUT;
BYTE_T vettore[27];
char crcchar[4];

char UINT32_PacketSize [4];
char ENUM_Packet_ID;
char UINT16_PacketCounter [2];
char UINT32_Timestamp [4];
char UINT32_Port0Value [4];
char UINT32_Port1Value [4];
char UINT32_Port2Value [4];
char UINT32_Port3Value [4];
char UINT32_CRC [4];

char zero ={0x00};


int port0value;
char port0valuechar[4];
int port1value;
char port1valuechar[4];
int port2value;
char port2valuechar[4];
int port3value;
char port3valuechar[4];


unsigned int i,j;


//char crc[4] = {0xA4 ,0x3D , 0xF4 , 0x40};
char packetsize[4] = {0x00 ,0x00 , 0x00 , 0x1F};



    DigitalIn mybutton(USER_BUTTON);
    DigitalOut myled(LED2);
    

void crc_cal();
void TGP_GET_GPI_CMD();
void TGP_GET_GPI_ANS();
    
int main()
{
    
    pc.baud(9600);
    
    
    while(1)
    {
        pc.attach(&TGP_GET_GPI_CMD,Serial::RxIrq);
    }
    
    
}

void TGP_GET_GPI_CMD()
{
    myled = 0;
        
        for(i=0; i<4; i++){
            UINT32_PacketSize[i] = pc.getc();
        }
        
        ENUM_Packet_ID=pc.getc();
        
        for(i=0; i<2; i++){
            UINT16_PacketCounter[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_Timestamp[i]=pc.getc();
        }        
        
        for(i=0; i<4; i++){
            UINT32_CRC[i]=pc.getc();
        }
        
        myled = 1;      
        
        TGP_GET_GPI_ANS();
}

void TGP_GET_GPI_ANS()
{
    
    port0value = 0;
    port1value = 0;
    port2value = 0;
    port3value = 0;
    
    port0value = port0.read();
    
    port0valuechar[0] = (port0value >> 24) & 0xFF;
    port0valuechar[1] = (port0value >> 16) & 0xFF;
    port0valuechar[2] = (port0value >> 8) & 0xFF;
    port0valuechar[3] = port0value & 0xFF;
    
    port1value = port1.read();
    
    port1valuechar[0] = (port1value >> 24) & 0xFF;
    port1valuechar[1] = (port1value >> 16) & 0xFF;
    port1valuechar[2] = (port1value >> 8) & 0xFF;
    port1valuechar[3] = port1value & 0xFF;
    
    port2value = port2.read();
    
    port1valuechar[0] = (port2value >> 24) & 0xFF;
    port2valuechar[1] = (port2value >> 16) & 0xFF;
    port2valuechar[2] = (port2value >> 8) & 0xFF;
    port2valuechar[3] = port2value & 0xFF;
    
    port3value = port3.read();
    
    port1valuechar[0] = (port3value >> 24) & 0xFF;
    port3valuechar[1] = (port3value >> 16) & 0xFF;
    port3valuechar[2] = (port3value >> 8) & 0xFF;
    port3valuechar[3] = port3value & 0xFF;
    
  
    for(i=0; i<4; i++){
            pc.printf("%c",packetsize[i]);
        }
        
    pc.printf("%c",ENUM_Packet_ID+1);
    
    for(i=0; i<2; i++){
            pc.printf("%c",UINT16_PacketCounter[i]);
        }
        
    for(i=0; i<4; i++){
            pc.printf("%c",UINT32_Timestamp[i]);
        }
        
        for(i=0; i<4; i++){
            pc.putc(port0valuechar[i]);
        }
        
        for(i=0; i<4; i++){
            pc.putc(port1valuechar[i]);
        }
        
        for(i=0; i<4; i++){
            pc.putc(port2valuechar[i]);
        }
        
        for(i=0; i<4; i++){
            pc.putc(port3valuechar[i]);
        }
        
        /*
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(port0value);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(port1value);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(port2value);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(zero);
    pc.putc(port3value);
    */
    crc_cal();
    
    
    for(i=0; i<4; i++){
            pc.putc(crcchar[i]);
        }
        
}

void crc_cal()
{   
    
    //def vettore
    j=0;
    for(i=0; i<4; i++)
    {
        vettore[j] = packetsize[i];
        j++;
    }
    
    vettore[j] = ENUM_Packet_ID+1;
    j++;
    
    for(i=0; i<2; i++)
    {
        vettore[j] = UINT16_PacketCounter[i];
        j++;
    }
    
    for(i=0; i<4; i++)
    {
        vettore[j] = UINT32_Timestamp[i];
        j++;
    }
    
    for(i=0; i<4; i++)
    {
        vettore[j] = port0valuechar[i];
        j++;
    }
        
    for(i=0; i<4; i++)
    {
        vettore[j] = port1valuechar[i];
        j++;
    }
        
    for(i=0; i<4; i++)
    {
        vettore[j] = port2valuechar[i];
        j++;
    }
        
    for(i=0; i<4; i++)
    {
        vettore[j] = port3valuechar[i];
        j++;
    }
    
    
    /*
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = port0value;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = port1value;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = port2value;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = zero;
    j++;
    vettore[j] = port3value;
    j++;
        */
    
    
    
    _Crc32Table_TGP_DUT.UINT32_Poly = 0xE7994FEB;
   _Crc32Table_TGP_DUT.UINT32_Init =  0xFFFFFFFF;
   _Crc32Table_TGP_DUT.BOOL_RefIn = FALSE;
   _Crc32Table_TGP_DUT.BOOL_RefOut =  FALSE;
   _Crc32Table_TGP_DUT.UINT32_XorOut = 0x00000000;

   /* Inizializzazione della tabella */
   ERROR_Value = CRC32BIT_LOOKUP_Init(&_Crc32Table_TGP_DUT);
   
   crc = CRC32BIT_LOOKUP_Compute(vettore,27,&_Crc32Table_TGP_DUT);
   
   crcchar[0] = (crc >> 24) & 0xFF;
    crcchar[1] = (crc >> 16) & 0xFF;
    crcchar[2] = (crc >> 8) & 0xFF;
    crcchar[3] = crc & 0xFF;
   
}