/* =======================================================================================
 * (c)
 * (c)                                   Sitael S.p.A
 * (c)
 * (c)                                 Libreria STD_Lib 
 * (c)
 * (c)                           Copyright (C) Sitael S.p.A.
 * (c)
 * (c)                             Tutti i diritti riservati.
 * (c)
 * (c) Questo programma e' tutelato dalle leggi sul copyright,  dalle  leggi  sui  diritti
 * (c) d'autore e  dai  trattati  internazionali.  La  riproduzione  o  distribuzione  non
 * (c) autorizzata di questo programma, o di parte di esso, sara' perseguibile  civilmente
 * (c) e penalmente.
 * (c)
 * =======================================================================================
 */

/* =======================================================================================
 * Informazioni del modulo
 * =======================================================================================
 * \brf  Tipi e definizioni della libreria STD_Lib
 *
 * \mod  Tipi e definizioni della libreria STD_Lib
 * \aut  Luigi Ingravallo
 * =======================================================================================
 */

/* =======================================================================================
 * Elenco delle modifiche (data - autore - descrizione)
 * =======================================================================================
 *
 * Ultima:
 *
 * 24/05/2017 - Luigi Ingravallo - Creazione del modulo
 * =======================================================================================
 */

#ifndef _TYPE_DEF_H
#define _TYPE_DEF_H

/* =======================================================================================
 * File inclusi
 * =======================================================================================
 */
#ifdef _UNICODE
#include <wchar.h>
#endif
/* =======================================================================================
 * Definizioni
 * =======================================================================================
 */


#ifndef _64BIT_PLATFORM
//#error Definire la piattaforma
#endif


/* TIPI SEMPLICI */

#ifndef _CHAR_T
   /* \typ Carattere            (Intero     segnato a  8 bit) */
#ifdef _UNICODE
   typedef wchar_t                  CHAR_T; 
#else
   typedef char                     CHAR_T; 
#endif
#define _CHAR_T   
#endif

#ifndef _SMALL_T
   /* \typ Dato generico        (Intero     segnato a  8 bit) */ 
   typedef signed char          SMALL_T; 
#define _SMALL_T   
#endif

#ifndef _INT8_T
   /* \typ Contatore            (Intero     segnato a  8 bit) */ 
   typedef signed char           INT8_T; 
#define _INT8_T   
#endif

#ifndef _BYTE_T
   /* \typ Dato generico        (Intero non segnato a  8 bit) */
   typedef unsigned char         BYTE_T; 
#define _BYTE_T   
#endif

#ifndef _UINT8_T
   /* \typ Contatore\dimensione (Intero non segnato a  8 bit) */
   typedef unsigned char        UINT8_T; 
#define _UINT8_T   
#endif

#ifndef _BOOL_T
   /* \typ Booleano             (Intero non segnato a 32 bit) */ 
   typedef int                   BOOL_T; 
#define _BOOL_T   
#endif

#ifndef _SHORT_T
   /* \typ Dato generico        (Intero     segnato a 16 bit) */ 
   typedef signed short         SHORT_T; 
#define _SHORT_T   
#endif

#ifndef _INT16_T
   /* \typ Contatore            (Intero     segnato a 16 bit) */
   typedef signed short         INT16_T; 
#define _INT16_T   
#endif

#ifndef _WORD_T
   /* \typ Dato generico        (Intero non segnato a 16 bit) */
   typedef unsigned short        WORD_T; 
#define _WORD_T   
#endif

#ifndef _UINT16_T
   /* \typ Contatore\dimensione (Intero non segnato a 16 bit) */
   typedef unsigned short      UINT16_T; 
#define _UINT16_T   
#endif

#ifndef _LONG_T
   /* \typ Dato generico        (Intero     segnato a 32 bit) */ 
   typedef signed long           LONG_T; 
#define _LONG_T   
#endif

#ifdef _16BIT_PLATFORM
#ifndef _INT32_T
   /* \typ Contatore            (Intero     segnato a 32 bit) */
   typedef signed long          INT32_T; 
#define _INT32_T   
#endif

#ifndef _DWORD_T
   /* \typ Dato generico        (Intero non segnato a 32 bit) */
   typedef unsigned long        DWORD_T; 
#define _DWORD_T   
#endif

#ifndef _UINT32_T
   /* \typ Contatore\dimensione (Intero non segnato a 32 bit) */  
   typedef unsigned long       UINT32_T; 
#define _UINT32_T   
#endif
#else
   #ifndef _INT32_T
   /* \typ Contatore            (Intero     segnato a 32 bit) */
   typedef signed int          INT32_T; 
#define _INT32_T   
#endif

#ifndef _DWORD_T
   /* \typ Dato generico        (Intero non segnato a 32 bit) */
   typedef unsigned int        DWORD_T; 
#define _DWORD_T   
#endif

#ifndef _QWORD_T
   /* \typ Dato generico        (Intero non segnato a 64 bit) */
   typedef unsigned long long         QWORD_T; 
#define _QWORD_T   
#endif

#ifndef _UINT32_T
   /* \typ Contatore\dimensione (Intero non segnato a 32 bit) */  
   typedef unsigned int       UINT32_T; 
#define _UINT32_T   
#endif
#endif


//#ifndef _MSC_VER

#ifndef _INT64_T
   /* \typ Contatore            (Intero     segnato a 64 bit) */  
   typedef signed long long     INT64_T; 
#define _INT64_T   
#endif

#ifndef _UINT64_T
   /* \typ Contatore\dimensione (Intero non segnato a 64 bit) */ 
   typedef unsigned long long  UINT64_T; 
#define _UINT64_T   
#endif

//#endif

   #ifndef _TIME_T
      /* \typ Tempo                (Intero non segnato a 32 bit) */ 
      typedef unsigned long         TIME_T; 
      #define _TIME_T
   #endif


#ifndef _ADDR_T
   /* \typ Indirizzo di memoria (Intero non segnato a 32 bit) */
   typedef unsigned long         ADDR_T;
#define _ADDR_T
#endif

#ifndef _ERROR_T
   /* \typ Codice di errore     (Intero non segnato a 32 bit) */
   typedef unsigned long       ERROR_T; 
#define _ERROR_T
#endif

#ifndef _HANDLE_T
   /* \typ Handle               (Intero non segnato a 16 bit) */
   typedef unsigned short      HANDLE_T; 
#define _HANDLE_T
#endif

#ifndef _BARRIER_T
   /* \typ Tag di inzio e fine di una barriera                */
   typedef unsigned char      BARRIER_T; 
#define _BARRIER_T
#endif

#ifndef _FLOAT_T
   /* \typ Dato generico        (Virgola mobile a 32 bit)     */
   typedef float                FLOAT_T; 
#define _FLOAT_T
#endif

#ifndef _DOUBLE_T
   /* \typ Dato generico        (Virgola mobile a 64 bit)     */
   typedef double              DOUBLE_T; 
#define _DOUBLE_T
#endif


/* COSTANTI PER IL TIPO BOOL_T */
#ifndef TRUE
   /* \def Valore "vero"  del tipo booleano BOOL_T */
   #define TRUE            (1) 
#endif
#ifndef FALSE
   /* \def Valore "falso" del tipo booleano BOOL_T */
   #define FALSE           (0) 
#endif

/* COSTANTI PER IL TIPO HANDLE_T */

#ifndef NULL_HANDLE
  /* \def Valore che indica un handle non valido */
  #define NULL_HANDLE (HANDLE_T)-1 
#endif

/* COSTANTI PER IL TIPO BARRIER_T */

/* \def Tag di inizio barriera */
#define BARRIER_BEGIN ((BARRIER_T) 0x0F) 
/* \def Tag di fine barriera   */ 
#define BARRIER_END   ((BARRIER_T) 0xF0) 

/* COSTANTI PER I PUNTATORI */
#ifndef NULL
   /* \def Puntatore nullo */
   #define NULL (0) 
#endif

/* COSTANTI PER GLI ERRORI */
#ifndef E_NULL
   /* \err Valore iniziale delle variabili di tipo ERROR_T   */
   #define E_NULL                                    (ERROR_T)   -1 
#endif
#ifndef E_OK
   /* \err Operazione completata con successo              */
   #define E_OK                                      (ERROR_T) 0x00 
#endif

   
/* \enum Giorni della settimana */
typedef enum
{
   RTC_DAYWEEK_SUNDAY    = 1    /* \val Domenica  */
  ,RTC_DAYWEEK_MONDAY    = 2    /* \val Lunedì    */
  ,RTC_DAYWEEK_TUESDAY   = 3    /* \val Martedì   */
  ,RTC_DAYWEEK_WEDNESDAY = 4    /* \val Mercoledì */
  ,RTC_DAYWEEK_THURSDAY  = 5    /* \val Giovedì   */
  ,RTC_DAYWEEK_FRIDAY    = 6    /* \val Venerdì   */
  ,RTC_DAYWEEK_SATURDAY  = 7    /* \val Sabato    */
} RTC_DAYOFWEEK_TE;

/* \enum Mesi */
typedef enum
{
   RTC_MONTH_JANUARY  = 1    /* \val Gennaio   */
  ,RTC_MONTH_FEBRUARY = 2    /* \val Febbraio  */
  ,RTC_MONTH_MARCH    = 3    /* \val Marzo     */
  ,RTC_MONTH_APRIL    = 4    /* \val Aprile    */
  ,RTC_MONTH_MAY      = 5    /* \val Maggio    */
  ,RTC_MONTH_JUNE     = 6    /* \val Giugno    */
  ,RTC_MONTH_JULY     = 7    /* \val Luglio    */
  ,RTC_MONTH_AUGUST   = 8    /* \val Agosto    */
  ,RTC_MONTH_SEPTEMBER = 9   /* \val Settembre */
  ,RTC_MONTH_OCTOBER   = 10  /* \val Ottobre   */
  ,RTC_MONTH_NOVEMBER  = 11  /* \val Novembre  */
  ,RTC_MONTH_DECEMBER  = 12  /* \val Dicembre  */
} RTC_MONTH_TE;


/* \str Dato di tipo Time */
typedef struct
{   
   /* \var Ore
    * \val [0..23]
    * \ini -
    */
   BYTE_T BYTE_Hours;
      
   /* \var Minuti
    * \val [00..59]
    * \ini -
    */
   BYTE_T BYTE_Minutes;   
   
   /* \var Secondi
    * \val [00..59]
    * \ini -
    */
   BYTE_T BYTE_Seconds;

   /* \var Centesimi di secondo
    * \val [00..99]
    * \ini -
    */
   BYTE_T BYTE_HundredthsOfSeconds;
      
} RTC_TIME_TS;

/* \str Dato di tipo Date */
typedef struct
{
   /* \var Giorno della settimana
    * \val [RTC_DAYWEEK_SUNDAY..RTC_DAYWEEK_SATURDAY]
    * \ini -
    */
   RTC_DAYOFWEEK_TE  ENUM_DayOfWeek;
   
   /* \var Data
    * \val [1..31]
    * \ini -
    */
   BYTE_T BYTE_Day;
      
   /* \var Mese
    * \val [RTC_MONTH_JANUARY..RTC_MONTH_DECEMBER]
    * \ini -
    */
   RTC_MONTH_TE ENUM_Month;

   /* \var Anno
    * \val [00..99]
    * \ini -
    */
   BYTE_T BYTE_Year;
   
} RTC_DATE_TS;

/* \str Dato di tipo DateTime */
typedef struct
{  
   /* \var Data
    * \val -
    * \ini -
    */
   RTC_DATE_TS Date;

   /* \var Orario
    * \val -
    * \ini -
    */
   RTC_TIME_TS Time;

} RTC_DATETIME_TS;

/* =======================================================================================
 * Macro                                                      
 * =======================================================================================
 */

/* =======================================================================================
 * \mac Esegue la funzione ERROR_Function solo se precedentemente non si sono
 *      verificati degli errori
 * 
 * \par [in] ERROR_Value : Codice di errore di tipo ERROR_T
 * \val -
 *
 * \par [in] ERROR_Function : Funzione che restituisce il tipo ERROR_T
 * \val -
 *
 * \ret -
 * =======================================================================================
 */
#define ERROR_Check(ERROR_Value, ERROR_Function) \
   if ((ERROR_Value) == E_OK)                    \
   {                                             \
      (ERROR_Value) = (ERROR_Function);          \
   }



#endif /* _TYPE_DEF_H */
