/* =======================================================================================
* (c)
* (c)                                  MEL SYSTEM S.r.l.
* (c)
* (c)                       Libreria VB32_Lib (Vital Board 32 Bit)
* (c)
* (c) La libreria VB32_Lib implementa le tutte le funzionalit� necessarie per  l'utilizzo
* (c) dei due processori AT91SAM9 della scheda VB32. La libreria permette di gestire
* (c) tutte  le  periferiche  interne  (DBGU, USART, SPI, ecc..) e  tutte le  periferiche
* (c) esterne (HILSCHER COM-C DPM, ecc..) del processore AT91SAM9.
* (c)
* (c) ===================================================================================
* (c)
* (c)                           Copyright (C) MEL SYSTEM S.r.l.
* (c)
* (c)                             Tutti i diritti riservati.
* (c)
* (c) Questo programma e' tutelato dalle leggi sul copyright,  dalle  leggi  sui  diritti
* (c) d'autore e  dai  trattati  internazionali.  La  riproduzione  o  distribuzione  non
* (c) autorizzata di questo programma, o di parte di esso, sara' perseguibile  civilmente
* (c) e penalmente.
* (c)
* =======================================================================================
*/

/* =======================================================================================
 * Elenco delle modifiche (data - autore - descrizione)
 * =======================================================================================
 *
 * Ultima:
 *
 * 23/04/2013 - M. Giannese - creazione del modulo
 * =======================================================================================
 */

/* =======================================================================================
* File inclusi
* =======================================================================================
*/
#include "CRC32BIT_LOOKUP_Int.h"

/* =======================================================================================
* Funzioni
* =======================================================================================
*/

/* =======================================================================================
* \fun Inizializza la struttura _CrcLUTable con i valori di CRC calcolati in funzione
*      dei valori di crcSettings
*

* \par [in] crcSettings: struttura delle impostazioni per il calcolo del CRC
* \val -
*
* \par [out] _CrcLUTable : la struttura che contiene la look up table
* \val -
*

* =======================================================================================
*/

ERROR_T CRC32BIT_LOOKUP_Init(CRC32BIT_LOOKUP_TS *pCRCLUTable)
{
ERROR_T ERROR_Value = E_NULL;
UINT32_T UINT32_elementInBytes = 0;
UINT32_T UINT32_bitInBytes = 0;
UINT32_T UINT32_value = 0;

    /* Viene calcolata la look-up table */
    if (pCRCLUTable->UINT32_Poly != 0)
    {
        for (UINT32_elementInBytes = 0; UINT32_elementInBytes < CRC32BIT_LOOKUP_NUMELEMENTS_IN_BYTE; ++UINT32_elementInBytes)
        {
            UINT32_value = UINT32_elementInBytes << 24;

            for (UINT32_bitInBytes = CRC32BIT_LOOKUP_NUMBITS_IN_BYTE; UINT32_bitInBytes > 0; --UINT32_bitInBytes)
            {
                if (UINT32_value & TOPBIT)
                {
                    UINT32_value = (UINT32_value << 1) ^ pCRCLUTable->UINT32_Poly;
                }
                else
                {
                    UINT32_value = (UINT32_value << 1);
                }
            }

            pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_elementInBytes] = UINT32_value;
        }

        ERROR_Value = E_OK;
    }
    else
    {
        ERROR_Value = E_STD_INVALID_PARAM;
    }
    return ERROR_Value;
}

/* =======================================================================================
* \fun Restituisce il CRC PROPER a 32 bit calcolato su un vettore di byte
*
* \par [in] vBYTE_Data: Puntatore al primo byte del vettore di cui calcolare il CRC
* \val 0x00..0xFF (1) [-]
*
* \par [in] UINT32_DataSize: Numero di byte del vettore:
* \val -
*
* \par [in] pCRCLUTable: look-up table
* \val - [-]
*
* \ret il crc calcolato
* =======================================================================================
*/
UINT32_T CRC32BIT_LOOKUP_Compute(const BYTE_T vBYTE_Data[],
                                 const UINT32_T UINT32_DataSize,
                                 const CRC32BIT_LOOKUP_TS *pCRCLUTable)
{
UINT32_T UINT32_Crc = 0;

   /* si esegue il calcolo del CRC32 proper */
   UINT32_Crc = CRC32BIT_LOOKUP_Update(0, vBYTE_Data, UINT32_DataSize, TRUE, pCRCLUTable);

   return UINT32_Crc;
}

/* =======================================================================================
* \fun Aggiorna e restituisce il CRC PROPER a 32 bit calcolato su un vettore di byte 
*
* \par [in] pSettings: Puntatore alla struttura delle impostazioni per il calcolo del CRC
* \val -
*
* \par [in] UINT32_PartialCrc : Il crc da cui partire
* \val -
*
* \par [in] vBYTE_Data: Puntatore al primo byte del vettore di cui calcolare il CRC
* \val -
*
* \par [in] UINT32_DataSize: Numero di byte del vettore:
* \val -
*
* \par [in] BOOL_FirstData: Indica che � il primo pacchetto di dati per cui si deve 
*           utilizzare il valore di inizializzazione del CRC
* \val -
*
* \par [in] BOOL_LastData: Indica che � l'ultimo pacchetto di dati per cui si deve
*           effetture la riflessione in uscita o l'XOR finale
* \val -
*
* \par [in] pCRCLUTable: look-up table
* \val -
*
* \ret il crc calcolato
* =======================================================================================
*/

UINT32_T CRC32BIT_LOOKUP_Update(const UINT32_T UINT32_PartialCrc,
                                const BYTE_T vBYTE_Data[], 
                                const UINT32_T UINT32_DataSize,
                                const BOOL_T BOOL_FirstData,
                                const CRC32BIT_LOOKUP_TS *pCRCLUTable)
{
UINT32_T UINT32_Crc = 0;
UINT32_T UINT32_Idx = 0;
UINT32_T UINT32_TableIdx = 0;
BYTE_T   BYTE_Value = 0;

   /* se si tratta del primo pacchetto dati il valore iniziale del CRC � 0xFFFFFFFF, altrimenti
   � quello parziale ricevuto in input */
   if (BOOL_FirstData == TRUE)
   {
      UINT32_Crc = pCRCLUTable->UINT32_Init;
   }
   else
   {
      UINT32_Crc = UINT32_PartialCrc;
   }/* Fine IF */

   UINT32_Idx = 0;


   /* per migliorare le performance si riducono il numero di confronti nel while
      effettuando i calcoli su blocchi di 8 byte */
   while ((UINT32_DataSize - UINT32_Idx) >= CRC32BIT_LOOKUP_BLOCK_SIZE)
   {
       /* verifica se nei parametri di inizializzazione � stata attivata la riflessione dei byte */
       if (pCRCLUTable->BOOL_RefIn == TRUE)
       {
            /* step 1 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 2 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 3 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 4 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 5 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 6 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 7 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;

            /* step 8 */
            BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
            UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
            UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
            UINT32_Idx = UINT32_Idx + 1;
       }
       else
       {
           /* step 1 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 2 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 3 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 4 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 5 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 6 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 7 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;

          /* step 8 */
          UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
          UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
          UINT32_Idx = UINT32_Idx + 1;
       }/* Fine IF */
   }/* Fine WHILE */

   /* si continua con i byte rimanenti */
   while (UINT32_Idx < UINT32_DataSize)
   {
       /* verifica se nei parametri di inizializzazione � stata attivata la riflessione dei byte */
       if (pCRCLUTable->BOOL_RefIn == TRUE)
       {
           BYTE_Value = CRC32BIT_LOOKUP_ReflectByte(vBYTE_Data[UINT32_Idx]);
           UINT32_TableIdx = (UINT32_T)(BYTE_Value ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
           UINT32_Crc =  pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
           UINT32_Idx = UINT32_Idx + 1;
       }
       else
       {
           UINT32_TableIdx = (UINT32_T)(vBYTE_Data[UINT32_Idx] ^ (UINT32_Crc >> CRC32BIT_LOOKUP_AUGMENTATION));
           UINT32_Crc = pCRCLUTable->_vDWORD_CRC32LookUpTable[UINT32_TableIdx] ^ (UINT32_Crc << CRC32BIT_LOOKUP_NUMBITS_IN_BYTE);
           UINT32_Idx = UINT32_Idx + 1;
       }
   }/* Fine WHILW */

   /* verifica se nei parametri di inizializzazione � attivata la riflessione in uscita */
   if (pCRCLUTable->BOOL_RefOut == TRUE)
   {
        UINT32_Crc = CRC32BIT_LOOKUP_ReflectUINT32(UINT32_Crc);
   }/* Fine IF */

   UINT32_Crc = UINT32_Crc ^ pCRCLUTable->UINT32_XorOut;

   return UINT32_Crc;
}

/* =======================================================================================
* \fun Riflette i bit di un byte
*
* \par [in] BYTE_Value : Byte da riflettere
* \val -
*
* \ret il byte riflesso
* =======================================================================================
*/
BYTE_T CRC32BIT_LOOKUP_ReflectByte(BYTE_T BYTE_Value)
{
BYTE_T   BYTE_ReflectedValue = 0;
BYTE_T   BYTE_Temp           = 0;
UINT16_T UINT16_NumOfShifts  = 0;
BYTE_T   BYTE_Mask           = 0;
UINT16_T UINT16_Idx          = 0;

   BYTE_ReflectedValue = 0;

   /* cicla su tutti i bit del byte per effettuarne la riflessione */
   UINT16_Idx = 0;
   while (UINT16_Idx < CRC32BIT_LOOKUP_NUMBITS_IN_BYTE)
   {
      BYTE_Temp = (BYTE_T) (BYTE_Value >> UINT16_Idx);

      if (BYTE_Temp & CRC32BIT_LOOKUP_BYTELSB_MASK)
      {
         UINT16_NumOfShifts = CRC32BIT_LOOKUP_NUMBITS_IN_BYTE - UINT16_Idx - 1;

         BYTE_Mask = (BYTE_T) (CRC32BIT_LOOKUP_BYTELSB_MASK << UINT16_NumOfShifts);

         BYTE_ReflectedValue = (BYTE_T) (BYTE_ReflectedValue ^ BYTE_Mask);
      }/* Fine IF */

      UINT16_Idx = UINT16_Idx + 1;
   }/* Fine WHILE */

   return BYTE_ReflectedValue;
}

/* =======================================================================================
* \fun Riflette i bit di una double word
*
* \par [in] UINT32_Value : Double Word da riflettere
* \val -
*
* \ret la double word riflessa
* =======================================================================================
*/
UINT32_T CRC32BIT_LOOKUP_ReflectUINT32(UINT32_T UINT32_Value)
{
UINT32_T  UINT32_ReflectedValue = 0;
UINT32_T  UINT32_Temp       = 0;
UINT32_T  UINT32_Mask       = 0;
UINT16_T UINT16_Idx         = 0;
UINT16_T UINT16_NumOfShifts = 0;

   UINT32_ReflectedValue = 0;

   /* cicla su tutti i bit della DWORD per effettuarne la riflessione */
   UINT16_Idx = 0;
   while (UINT16_Idx < CRC32BIT_LOOKUP_NUMBITS_UINT32)
   {
      UINT32_Temp = (UINT32_Value >> UINT16_Idx);

      if (UINT32_Temp & CRC32BIT_LOOKUP_UINT32LSB_MASK)
      {
         UINT16_NumOfShifts = CRC32BIT_LOOKUP_NUMBITS_UINT32 - UINT16_Idx - 1;

         UINT32_Mask = (UINT32_T) (CRC32BIT_LOOKUP_UINT32LSB_MASK << UINT16_NumOfShifts);

         UINT32_ReflectedValue = (UINT32_ReflectedValue ^ UINT32_Mask);
      }/* Fine IF */

      UINT16_Idx = UINT16_Idx + 1;
   }/* Fine WHILE */

   return UINT32_ReflectedValue;
}
