#include "mbed.h"
#include "TYPE_Def.h"
#include "CRC32BIT_LOOKUP_Ext.h"

Serial pc(USBTX, USBRX); // tx, rx

UINT32_T crc;
ERROR_T ERROR_Value;
CRC32BIT_LOOKUP_TS _Crc32Table_TGP_DUT;
BYTE_T vettore[143];
char crcchar[4];

//Ticker get;

int resto;    // CRC
int c;  
//unsigned short value;
//int value;

char UINT32_PacketSize [4];
char ENUM_Packet_ID;
char UINT16_PacketCounter [2];
char UINT32_Timestamp [4];
char UINT32_AnalogMask [4];
int vUNIT32_PortAnalogValue [32];
char vUNIT32_PortAnalogValue_char [128];
char UINT32_CRC [4];

unsigned int i,j;


//char crc[4]   = {0x49 ,0xC3 , 0xBD , 0x0A};
char packetsize[4] = {0x00 ,0x00 , 0x00 , 0x93};

DigitalOut myled(LED2);
AnalogIn val(PA_0);


void TGP_ANALOG_IN_CMD();
void TGP_ANALOG_IN_ANS();
void crc_cal();
void getanalog();
    
int main()
{
    
    pc.baud(9600);
    
    
    
    pc.attach(&TGP_ANALOG_IN_CMD,Serial::RxIrq);
        
    
    
    
}

void TGP_ANALOG_IN_CMD()
{
    myled = 0;
        
        for(i=0; i<4; i++){
            UINT32_PacketSize[i] = pc.getc();
        }
        
        ENUM_Packet_ID=pc.getc();
        
        for(i=0; i<2; i++){
            UINT16_PacketCounter[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_Timestamp[i]=pc.getc();
        }        
        
        for(i=0; i<4; i++){
            UINT32_AnalogMask[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_CRC[i]=pc.getc();
        }
        
        myled = 1;      
        
        for(i=0;i<32;i++)
        {
            vUNIT32_PortAnalogValue[i]=0;
        }
    
        
        getanalog();
        //get.attach(&getanalog,0.5); //peiodo da cambiare
        
        j = 0;
        for(i=0;i<32;i++)
        {
            vUNIT32_PortAnalogValue_char[j] = (vUNIT32_PortAnalogValue[i] >> 24) & 0xFF;
            j++;
            vUNIT32_PortAnalogValue_char[j] = (vUNIT32_PortAnalogValue[i] >> 16) & 0xFF;
            j++;
            vUNIT32_PortAnalogValue_char[j] = (vUNIT32_PortAnalogValue[i] >> 8) & 0xFF;
            j++;
            vUNIT32_PortAnalogValue_char[j] = vUNIT32_PortAnalogValue[i] & 0xFF;
            j++;
        }
        
        //per la prova del crc
        /*
        vUNIT32_PortAnalogValue_char[0] = 0x00;
        vUNIT32_PortAnalogValue_char[1] = 0x00;
        vUNIT32_PortAnalogValue_char[2] = 0x7D;
        vUNIT32_PortAnalogValue_char[3] = 0x00;
        */
        
        crc_cal();
        
        
        crcchar[0] = (crc >> 24) & 0xFF;
        crcchar[1] = (crc >> 16) & 0xFF;
        crcchar[2] = (crc >> 8) & 0xFF;
        crcchar[3] = crc & 0xFF;
        
        
        TGP_ANALOG_IN_ANS();
        
}


void TGP_ANALOG_IN_ANS()
{
    
    
    for(i=0; i<4; i++){
            pc.printf("%c",packetsize[i]);
    }
        
    pc.printf("%c",ENUM_Packet_ID+1);
    
    for(i=0; i<2; i++){
            pc.printf("%c",UINT16_PacketCounter[i]);
        }
        
    for(i=0; i<4; i++){
            pc.printf("%c",UINT32_Timestamp[i]);
        }
    
    for(i=0;i<128;i++)
    {
        pc.putc(vUNIT32_PortAnalogValue_char[i]);   
    }
    
        
    for(i=0; i<4; i++){
            pc.printf("%c",UINT32_AnalogMask[i]);
    }
    
    for(i=0; i<4; i++){
            pc.putc(crcchar[i]);
    }
    
    myled = 0;
}


void crc_cal()
{
    j=0;
    for(i=0; i<4; i++){
            vettore[j] = packetsize[i];
            j++;
    }
    
    vettore[j] = ENUM_Packet_ID+1;
    j++;
    
    for(i=0; i<2; i++){
            vettore[j] = UINT16_PacketCounter[i];
            j++;
        }
        
    for(i=0; i<4; i++){
            vettore[j] = UINT32_Timestamp[i];
            j++;
        }
        
    for(i=0;i<128;i++)
    {
        vettore[j] = vUNIT32_PortAnalogValue_char[i];   
        j++;
    }
    
    for(i=0; i<4; i++){
            vettore[j] = UINT32_AnalogMask[i];
            j++;
    }
    
    
    _Crc32Table_TGP_DUT.UINT32_Poly = 0xE7994FEB;
   _Crc32Table_TGP_DUT.UINT32_Init =  0xFFFFFFFF;
   _Crc32Table_TGP_DUT.BOOL_RefIn = FALSE;
   _Crc32Table_TGP_DUT.BOOL_RefOut =  FALSE;
   _Crc32Table_TGP_DUT.UINT32_XorOut = 0x00000000;

   /* Inizializzazione della tabella */
   ERROR_Value = CRC32BIT_LOOKUP_Init(&_Crc32Table_TGP_DUT);
   
   crc = CRC32BIT_LOOKUP_Compute(vettore,143,&_Crc32Table_TGP_DUT);
}

void getanalog()
{
    vUNIT32_PortAnalogValue[0]=val.read_u16();
        //value = val.read_u16();
        //vUNIT32_PortAnalogValue[31] = (value/0xFFFF)*0xFFFFFFFF;
}
