/* =======================================================================================
 * (c)
 * (c)                                  MEL SYSTEM S.r.l.
 * (c)
 * (c)                       Libreria VB32_Lib (Vital Board 32 Bit)
 * (c)
 * (c) La libreria VB32_Lib implementa le tutte le funzionalità necessarie per  l'utilizzo
 * (c) dei due processori AT91SAM9 della scheda VB32. La libreria permette di gestire
 * (c) tutte  le  periferiche  interne  (DBGU, USART, SPI, ecc..) e  tutte le  periferiche
 * (c) esterne (HILSCHER COM-C DPM, ecc..) del processore AT91SAM9.
 * (c)
 * (c) ===================================================================================
 * (c)
 * (c)                           Copyright (C) MEL SYSTEM S.r.l.
 * (c)
 * (c)                             Tutti i diritti riservati.
 * (c)
 * (c) Questo programma e' tutelato dalle leggi sul copyright,  dalle  leggi  sui  diritti
 * (c) d'autore e  dai  trattati  internazionali.  La  riproduzione  o  distribuzione  non
 * (c) autorizzata di questo programma, o di parte di esso, sara' perseguibile  civilmente
 * (c) e penalmente.
 * (c)
 * =======================================================================================
 */

/* =======================================================================================
 * Informazioni del modulo
 * =======================================================================================
 * \brf CRC32BIT_LOOKUP
 *
 * \mod Il modulo CRC32BIT_LOOKUP permette di calcolare crc a 32 bit di vettori di BYTE
 *      o di WORD utilizzando una tabella di lookup
 *
 * \aut Michele Giannese
 * =======================================================================================
 */

/* =======================================================================================
 * Elenco delle modifiche (data - autore - descrizione)
 * =======================================================================================
 *
 * Ultima:
 *
 * 23/04/2013 - M. Giannese - creazione del modulo
 * =======================================================================================
 */

#ifndef _CRC32BIT_LOOKUP_EXT_H
#define _CRC32BIT_LOOKUP_EXT_H

/* =======================================================================================
 * File inclusi
 * =======================================================================================
 */
#include "TYPE_Def.h"


/* =======================================================================================
 * Macro
 * =======================================================================================
 */

/* =======================================================================================
 * Definizioni
 * =======================================================================================
 */

/* \str Struttura contenente la look-up table per il calcolo ottimizzato del CRC a 32 bit */
typedef struct
{
   /* \var polynomial Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    UINT32_T UINT32_Poly;
    
   /* \var Initial value Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    UINT32_T UINT32_Init;
    
   /* \var Input reflection Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    BOOL_T  BOOL_RefIn;
   /* \var Output reflection Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    BOOL_T  BOOL_RefOut;
   /* \var XOR value Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    UINT32_T UINT32_XorOut;

    /* \var Look-up Table Crc 32 bit
    * \val 0x00000000..0xFFFFFFFF (1) [-]
    * \ini 0
    */
    DWORD_T _vDWORD_CRC32LookUpTable[256];
} CRC32BIT_LOOKUP_TS;

/* =======================================================================================
 * Prototipi delle funzioni
 * =======================================================================================
 */

#if defined(__cplusplus)
extern "C"
{
#endif /* __cplusplus */

/* Restituisce il CRC PROPER a 32 bit calcolato su un vettore di byte */
UINT32_T CRC32BIT_LOOKUP_Compute(const BYTE_T vBYTE_Data[],
                                 const UINT32_T UINT32_DataSize,
                                 const CRC32BIT_LOOKUP_TS *pCRCLUTable);

/* Valorizza la look-up table in funzione del valore crcSettings */
ERROR_T CRC32BIT_LOOKUP_Init(CRC32BIT_LOOKUP_TS *pCRCLUTable);

/* Aggiorna e restituisce il CRC PROPER a 32 bit calcolato su un vettore di byte */
UINT32_T CRC32BIT_LOOKUP_Update(const UINT32_T UINT32_PartialCrc,
                                const BYTE_T vBYTE_Data[],
                                const UINT32_T UINT32_DataSize,
                                const BOOL_T BOOL_FirstData,
                                const CRC32BIT_LOOKUP_TS *pCRCLUTable);

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* _CRC32BIT_LOOKUP_EXT_H */
