#include "mbed.h"

// tempo in secondi dl Ticker
#define SECPERTICK 1

DigitalOut MyLed(LED1);
AnalogIn In20(PA_0); //20 Volt
AnalogIn In5(PB_0); //5 Volt
AnalogIn In42(PC_0); //4.2 Volt
Serial pc(USBTX,USBRX);
Serial MyBle(PA_9,PA_10);

// numero di volte che il programma entra nella funzione Ticker
int nCountTick;
int nOldCountTick;
volatile bool bSwitch;
volatile float fSommaMisureVPiezo = 0.0;
volatile float fSommaMisureVOut = 0.0;
volatile float fSommaMisureVBatt = 0.0;
volatile int nContaMisure= 0;
volatile float fAverageVBatt =0.0;
volatile float fAverageVOut =0.0;
volatile float fAverageVPiezo =0.0;

// variabili contenenti le tensioni lette con gli ADC
float fOut;
float fPiezo;
float fBatt;
float temp;
char stringa[128];
char stringapc[128];
const float R1 = 562000.0;
const float R2 = 100000.0;
const float R3 = 274000.0;
const float R4 = 562000.0;
const float  R5 = 100000.0;     
const float  R6 = 332000.0;
int contStr = 0;
int contStrPc = 0;

// indice per i cicli
int nIndex;



Ticker TimeTick;

void TimeTickFunction()
{   
        if(bSwitch == true) //Variabile accensione o spegnimento trasmissione dati(cambia attraverso uno switch sull'app)
        {
            // Calcolo valore medio di: VPiezo,VOut,VBatt
            fAverageVBatt = fSommaMisureVBatt/nContaMisure;     
            fAverageVPiezo = fSommaMisureVPiezo/nContaMisure;
            fAverageVOut = fSommaMisureVOut/nContaMisure;
            //  Reinizzializzo le variabili necessarie alla somma
            fSommaMisureVBatt =0.0;
            fSommaMisureVOut = 0.0;
            fSommaMisureVPiezo = 0.0;
            /*  Mando Valori medi all'applicazione tramite Bluetooth utilizzando il seguente protocollo:
                *P Piezo
                *O VOut
                *B VBatt    
                                                                                                        */
            MyBle.printf("*P%.2f",fAverageVPiezo);
            pc.printf("PC>: P %.2f\n\r",fAverageVPiezo);
            MyBle.printf("*O%.2f",fAverageVOut);
            pc.printf("PC>: O %.2f\n\r",fAverageVOut);
            MyBle.printf("*B%.2f",fAverageVBatt);
            pc.printf("PC>: B %.2f\n\r",fAverageVBatt);
            
            // indice di tick
            nCountTick++;
            // reinizializzo contatore di misure
            nContaMisure =0;
            //Mando valori medi in seriale al pc per questioni di diagnostica
            pc.printf("Secondi= %d; fPiezo = %.3f; fOut = %.3f; fBatt = %.3f\n\r", (nCountTick*SECPERTICK), fAverageVPiezo, fAverageVOut, fAverageVBatt); 
        }
        
        

   
}
int main()
{
    //Inizializzazione del contatore delle misure
    nContaMisure =0;
    TimeTick.attach(&TimeTickFunction,SECPERTICK);
    char cRxChar;
    char pcRxChar;
    while(true)
    {   
        fPiezo=In20.read();         //Acquisice la tensione in dal piezo
        fPiezo=fPiezo*3.3;          //Converte la tensione del piezo in un range da 0 a 3.3 Volt
        fPiezo= (fPiezo/(R2/(R1+R2)));      //Riporta il valore di tensione a prima del cambiamento causato dai partitori di tensione
        fSommaMisureVPiezo += fPiezo;
        fOut=In5.read();            //Acquisice la tensione in uscita dall'alimentatore
        fOut=fOut*3.3;              //Converte la tensione del tensione in uscita in un range da 0 a 3.3 Volt
        fOut= (fOut/(R4/(R3+R4)));  //Riporta il valore di tensione a prima del cambiamento causato dai partitori di tensione
        fSommaMisureVOut += fOut;
        fBatt=In42.read();          //Acquisice la tensione della batteria
        fBatt=fBatt*3.3;            //Converte la tensione della batteria in un range da 0 a 3.3 Volt
        fBatt= (fBatt/(R6/(R5+R6)));    //Riporta il valore di tensione a prima del cambiamento causato dai partitori di tensione
        fSommaMisureVBatt +=fBatt;
        nContaMisure++;
    
        
    
    
    
    
        //Non ci possono essere trasmissioni contemporanee da Bluetooth e da Usb
        
        //Protocollo comunicazione, invio messaggi da PC a Bluetooth
        while(MyBle.readable()) 
        {
            cRxChar = MyBle.getc();
            //Protocollo di accensione e spegnimento della visualizzazione delle tensioni sull'APP
            if(cRxChar == 'S')
            {   pc.printf("PC<: Communication switched on\n\r");
                MyBle.printf("*#Communication switched on\n\r*");
                bSwitch = true;
                
            }
            
            if(cRxChar == 'E')
            {   
                pc.printf("PC<: Communication switched off\n\r");
                MyBle.printf("*#Communication switched off\n\r*");
                bSwitch = false;
            }
            
            //Protocollo comunicazione, invio messaggi da Bluetooh a PC
            if(cRxChar == '#')
            {
                stringa[0] = '#';               
                for(int i = 1;i<=128;i++)
                {
                    stringa[i] = MyBle.getc(); //Acquisisce caratteri dallo smartphone e li inserisco in un'array
                    contStr = i;
                    if(stringa[i] == '#') //Termina il caricamento dell'array quando riceve il '#'
                    {
                        break;
                    }
                
                }
                pc.printf("\rPC<: ");
                
                for(int i = 1;i<contStr;i++)
                    //Stampa sulla seriale del PC l'array caricato precedentemente    
                {    pc.printf("%c", stringa[i]);
                    
                }
                pc.printf("\n\r");
            }
             
        }//if(MyBle.readable())
                                                                // SISTEMA DI COMUNICAZIONE FUNZIONANTE
            while(pc.readable()) 
            {
                pcRxChar = pc.getc();
                switch(pcRxChar)
                {
                    case '#':
                        if(stringapc[0] == '#')
                        {
                            pc.printf("\rPC>: ");
                            MyBle.putc('*');
                            
                            for(int i = 0;i<contStrPc;i++)
                            {
                                MyBle.printf("%c" , stringapc[i]);       
                                pc.printf("%c", stringapc[i]);
                            }
                            pc.printf("\n\r");
                            MyBle.printf("\n\r*");
                            for(int i = 0;i<contStrPc;i++)
                            {
                                stringapc[i] = ' ';
                            }
                            contStrPc = 0;
                             
                            
                        }
                        else
                        {
                            stringapc[0] = '#';
                            contStrPc++;
                        }
                    break;
                    default:
                        if(stringapc[0] == '#')
                        {
                            stringapc[contStrPc] = pcRxChar;
                            contStrPc++;
                        }
                    break;
                    
            }//switch(pcRxChar)
        }//while(MyBle.readable())
            
    } //while (true)    
        
}
        
        
        