#include "mbed.h"
#include "TYPE_Def.h"
#include "CRC32BIT_LOOKUP_Ext.h"


#define add (0x22)
#define idstr (0x14)
#define idspr (0x16)


I2C i2c1(I2C_SDA, I2C_SCL);
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled(LED2);
DigitalOut pin(D12);

UINT32_T crc;
ERROR_T ERROR_Value;
CRC32BIT_LOOKUP_TS _Crc32Table_TGP_DUT;
BYTE_T vettore[13];
char crcchar[4];

int i,j,n;

char UINT32_PacketSize [4];
char ENUM_Packet_ID;
char UINT16_PacketCounter [2];
char UINT32_Timestamp [4];
char UINT16_PortNumber [2];
char UINT32_BaudRate [4];
char UINT32_CRC [4];

int hz;
int ackr;
int ackw;

char packetsize[4] = {0x00 ,0x00 , 0x00 , 0x11};

void crc_cal();
void TGP_CMD();
void TGP_START_READ_ACK();
void TGP_STOP_READ_ACK();
void TGP_START_WRITE_ACK();
void TGP_STOP_WRITE_ACK();

char data;
char dataout;

int main()
{
    pin = 0;
    
    ENUM_Packet_ID = 0;
    data = 0;
    dataout = 0;
    
    
    ackr = 1;
    ackw = 1;
    
    pc.attach(&TGP_CMD,Serial::RxIrq);
    
    j=0;
    n=0;
    
    
    
}

void crc_cal()
{   
    
    //def vettore
    j=0;
    for(i=0; i<4; i++){
            vettore[j] = packetsize[i];
            j++;
    }
    
    vettore[j] = ENUM_Packet_ID+1;
    j++;
    
    for(i=0; i<2; i++){
            vettore[j] = UINT16_PacketCounter[i];
            j++;
        }
        
    for(i=0; i<4; i++){
            vettore[j] = UINT32_Timestamp[i];
            j++;
        }
        
    for(i=0;i<2;i++)
    {
        vettore[j] = UINT16_PortNumber[i];   
        j++;
    }    
    
    
    _Crc32Table_TGP_DUT.UINT32_Poly = 0xE7994FEB;
   _Crc32Table_TGP_DUT.UINT32_Init =  0xFFFFFFFF;
   _Crc32Table_TGP_DUT.BOOL_RefIn = FALSE;
   _Crc32Table_TGP_DUT.BOOL_RefOut =  FALSE;
   _Crc32Table_TGP_DUT.UINT32_XorOut = 0x00000000;

   /* Inizializzazione della tabella */
   ERROR_Value = CRC32BIT_LOOKUP_Init(&_Crc32Table_TGP_DUT);
   
   crc = CRC32BIT_LOOKUP_Compute(vettore,13,&_Crc32Table_TGP_DUT);
   
   crcchar[0] = (crc >> 24) & 0xFF;
    crcchar[1] = (crc >> 16) & 0xFF;
    crcchar[2] = (crc >> 8) & 0xFF;
    crcchar[3] = crc & 0xFF;
   
}

void TGP_CMD()
{
    myled = 0;
    
    for(i=0; i<4; i++)
    {
            UINT32_PacketSize[i] = pc.getc();
    }
    
    ENUM_Packet_ID = pc.getc();
    
    if(ENUM_Packet_ID == idstr)
    {
        for(i=0; i<2; i++){
            UINT16_PacketCounter[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_Timestamp[i]=pc.getc();
        }
        
        for(i=0; i<2; i++){
            UINT16_PortNumber[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_BaudRate[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_CRC[i]=pc.getc();
        }
        
        myled = 1;
        
        TGP_START_READ_ACK();
        
    } 
    else if(ENUM_Packet_ID == idspr)
    {
        for(i=0; i<2; i++){
            UINT16_PacketCounter[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_Timestamp[i]=pc.getc();
        }
        
        for(i=0; i<2; i++){
            UINT16_PortNumber[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_CRC[i]=pc.getc();
        }
        
        myled = 1;
        
        TGP_STOP_READ_ACK();
        
    }
    
    else 
    {
        while(1)
        {
            myled = 1;
            wait(0.1);
            myled = 0;
            wait(0.1);   
        }
    }
    
    
}


void TGP_START_READ_ACK()
{
    for(i=0; i<4; i++)
    {
        pc.printf("%c",packetsize[i]); 
    }
    
    pc.printf("%c",ENUM_Packet_ID+1);
    
    for(i=0; i<2; i++)
    {
        pc.printf("%c",UINT16_PacketCounter[i]);
    }
        
    for(i=0; i<4; i++)
    {
        pc.printf("%c",UINT32_Timestamp[i]);
    }
    
    for(i=0; i<2; i++)
    {
        pc.putc(UINT16_PortNumber[i]);
    }
    
    crc_cal();
    
    for(i=0; i<4; i++)
    {
        pc.putc(crcchar[i]);
    }
    
    myled = 0;
    pin = 1;
}

void TGP_STOP_READ_ACK()
{
    for(i=0; i<4; i++)
    {
        pc.printf("%c",packetsize[i]); 
    }
    
    pc.printf("%c",ENUM_Packet_ID+1);
    
    for(i=0; i<2; i++)
    {
        pc.printf("%c",UINT16_PacketCounter[i]);
    }
        
    for(i=0; i<4; i++)
    {
        pc.printf("%c",UINT32_Timestamp[i]);
    }
    
    for(i=0; i<2; i++)
    {
        pc.putc(UINT16_PortNumber[i]);
    }
    
    crc_cal();
    
    for(i=0; i<4; i++)
    {
        pc.putc(crcchar[i]);
    }
    
    myled = 0;
    pin = 0;
}
