/* =======================================================================================
 * (c)
 * (c)                                  Sitael S.p.A.
 * (c)
 * (c)                             Componente ERROR_STD
 * (c)
 * (c)
 * (c) ===================================================================================
 * (c)
 * (c)                            Copyright (C) Sitael S.p.A.
 * (c)
 * (c)                             Tutti i diritti riservati.
 * (c)
 * (c) Questo programma e' tutelato dalle leggi sul copyright,  dalle  leggi  sui  diritti
 * (c) d'autore e  dai  trattati  internazionali.  La  riproduzione  o  distribuzione  non
 * (c) autorizzata di questo programma, o di parte di esso, sara' perseguibile  civilmente
 * (c) e penalmente.
 * (c)
 * =======================================================================================
 */
/* =======================================================================================
 * Informazioni del modulo
 * =======================================================================================
 */
 /*! \file   ERROR_STD_Def.h
 *           Questo file definisce i codici di errore della libreria
 *
 *  \details Questo file definisce i codici di errore della libreria 
 *          
 *
 *  \author  Orlando Petrone
 */

/* =======================================================================================
 * Elenco delle modifiche (data - autore - descrizione)
 * =======================================================================================
 * Ultima:
 *
 * 03/11/2015 - O. Petrone - creazione del modulo
 * =======================================================================================
 */
#ifndef _ERROR_STD_DEF_H
#define _ERROR_STD_DEF_H

/* =======================================================================================
 * File inclusi
 * =======================================================================================
 */
 #include "TYPE_Def.h" /* Contiene la definizione di ERROR_T */

/* =======================================================================================
 * Definizioni
 * =======================================================================================
 */

/*! 
 *       Codice identificativo della libreria
 */
#define STD_LIB_CODE                 (0x82)

#define E_STD_INVALID_PARAM                  (ERROR_T) 0x01 /*!< Parametro non valido */
#define E_STD_INVALID_STATE                  (ERROR_T) 0x02 /*!< Stato non ammesso */
#define E_STD_NULL_POINTER                   (ERROR_T) 0x03 /*!< Puntatore nullo */
#define E_STD_CHECKSUM                       (ERROR_T) 0x04 /*!< Checksum non valida */
#define E_STD_SEQ_NUMBER                     (ERROR_T) 0x05 /*!< Errore di sequence counter */
#define E_STD_MESSAGE_INVALID_SIZE           (ERROR_T) 0x06 /*!< Dimensione messaggio non valida */
#define E_STD_DATA_MAX_SIZE                  (ERROR_T) 0x08 /*!< Errore sulla massima dimensione */
#define E_STD_FRAME_INVALID_SIZE             (ERROR_T) 0x09 /*!< Dimensione non valida */
#define E_STD_DECODING_FRAME                 (ERROR_T) 0x0A /*!< Errore decodifica frame */


/*! \def MODULE_STD_ID_TE
 *       Moduli e componenti appartenenti all'applicazione INTLOCK.
 */
typedef enum
{
   MODULE_STD_ID_IODEB           = 0x01 /*!< Modulo IODEB */
   ,MODULE_STD_ID_NVCP           = 0x02 /*!< Modulo NVCP  */
   ,MODULE_STD_ID_NVCPDL         = 0x03 /*!< Modulo NVCPDL  */
   ,MODULE_STD_ID_INVALID        = 0xFF /*!< Identificativo modulo valido */ 


} MODULE_STD_ID_TE;


/* =======================================================================================
 * Macro
 * =======================================================================================
 */
 
 /*! \def ERROR_FormatAPP(ENUM_ModuleID, ERROR_Value)
 *       Crea una parola da 32 bit con le informazioni sul modulo che ha generato l'errore 
 *       ed il tipo d'errore.
 * Nella formattazione degli errori si usa il seguente formato
 * Il formato degli errori  (32 bit) e'
 *      
 * |   (1° byte)  |  (2° byte)|   (3° byte)  |  (4° byte)    |     
 * |  Byte piu'   |           |              | Byte meno     |
 * | significativo|           |              | significativo |
 * ----------------------------------------------------------   
 * | Application/ |  Modulo   |   Codice  Errore Rilevato    |
 * |   Library    |           |   Modulo     |   Errore      |
 * |              |           |   [0x0000......0xFFFF]       |
 *
 *  Per identificare la libreria di provenienza si aggiorna il
 *  2° byte piu' significativo
 */
#define ERROR_FormatSTD(ENUM_ModuleID, ERROR_Value)   \
   (((ERROR_T)((STD_LIB_CODE << 24) | (ENUM_ModuleID) << 16)) | (ERROR_Value))




#endif /* _ERROR_STD_DEF_H */
