/* =======================================================================================
 * (c)
 * (c)                                  MEL SYSTEM S.r.l.
 * (c)
 * (c)                       Libreria VB32_Lib (Vital Board 32 Bit)
 * (c)
 * (c) La libreria VB32_Lib implementa le tutte le funzionalità necessarie per  l'utilizzo
 * (c) dei due processori AT91SAM9 della scheda VB32. La libreria permette di gestire
 * (c) tutte  le  periferiche  interne  (DBGU, USART, SPI, ecc..) e  tutte le  periferiche
 * (c) esterne (HILSCHER COM-C DPM, ecc..) del processore AT91SAM9.
 * (c)
 * (c) ===================================================================================
 * (c)
 * (c)                           Copyright (C) MEL SYSTEM S.r.l.
 * (c)
 * (c)                             Tutti i diritti riservati.
 * (c)
 * (c) Questo programma e' tutelato dalle leggi sul copyright,  dalle  leggi  sui  diritti
 * (c) d'autore e  dai  trattati  internazionali.  La  riproduzione  o  distribuzione  non
 * (c) autorizzata di questo programma, o di parte di esso, sara' perseguibile  civilmente
 * (c) e penalmente.
 * (c)
 * =======================================================================================
 */

/* =======================================================================================
 * Elenco delle modifiche (data - autore - descrizione)
 * =======================================================================================
 *
 * Ultima:
 *
 * 23/04/2013 - M. Giannese - creazione del modulo
 * =======================================================================================
 */

#ifndef _CRC32_LOOKUP_INT_H
#define _CRC32_LOOKUP_INT_H

/* =======================================================================================
 * File inclusi
 * =======================================================================================
 */

#include "CRC32BIT_LOOKUP_Ext.h"
#include "ERROR_STD_Def.h"
//#include "WORD_Ext.h" 

/* =======================================================================================
 * Definizioni
 * =======================================================================================
 */

/* \def Numero di bit in un byte */
#define CRC32BIT_LOOKUP_NUMBITS_IN_BYTE               8
/* \def Numero di bit in un byte */
#define CRC32BIT_LOOKUP_NUMELEMENTS_IN_BYTE           256
/* \def Numero di bit in una double word */
#define CRC32BIT_LOOKUP_NUMBITS_UINT32                32
/* \def Differenza di dimensione tra intero a 32 bit e byte */
#define CRC32BIT_LOOKUP_AUGMENTATION                 (CRC32BIT_LOOKUP_NUMBITS_UINT32 - CRC32BIT_LOOKUP_NUMBITS_IN_BYTE)
/* \def Maschera del bit meno significativo di una double word */
#define CRC32BIT_LOOKUP_UINT32LSB_MASK               (UINT32_T)1
 /* \def Maschera del bit meno significativo di un byte */
#define CRC32BIT_LOOKUP_BYTELSB_MASK                 (BYTE_T)0x01
/* \def Maschera del bit più significativo di una double word */
#define CRC32BIT_LOOKUP_UINT32MSB_MASK               (UINT32_T)0x80000000
/* \def dimensione del blocco per il calcolo veloce del CRC */
#define CRC32BIT_LOOKUP_BLOCK_SIZE                   8

#define TOPBIT                                       ((UINT32_T)(1<<(CRC32BIT_LOOKUP_NUMBITS_UINT32-1)))

/* =======================================================================================
 * Macro
 * =======================================================================================
 */

/* =======================================================================================
 * Prototipi delle funzioni
 * =======================================================================================
 */

/* Riflette i bit di un byte */
BYTE_T CRC32BIT_LOOKUP_ReflectByte(BYTE_T BYTE_Value);

/* Riflette i bit di una double word */
UINT32_T CRC32BIT_LOOKUP_ReflectUINT32(UINT32_T UINT32_Value);

#endif /* _CRC32_LOOKUP_INT_H */
