#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
AnalogOut out(PA_4);

char UINT32_PacketSize [4];
char ENUM_Packet_ID;
char UINT16_PacketCounter [2];
char UINT32_Timestamp [4];
char vUNIT32_PortAnalogValue [128];
char UINT32_AnalogMask [4];
char UINT32_CRC [4];

unsigned int i;
uint16_t n = 0;


char crc[4] = {0x4D ,0x83 , 0xE8 , 0x47};
char packetsize[4] = {0x00 ,0x00 , 0x00 , 0x0F};

DigitalOut myled(LED2);
AnalogIn val(PA_0);


void TGP_ANALOG_IN_CMD();
void TGP_ANALOG_IN_ANS();
void setport();
    
int main()
{
    
    pc.baud(9600);
    
    
    while(1)
    {
        pc.attach(&TGP_ANALOG_IN_CMD,Serial::RxIrq);
    }
    
    
}

void TGP_ANALOG_IN_CMD()
{
    myled = 0;
        
        for(i=0; i<4; i++){
            UINT32_PacketSize[i] = pc.getc();
        }
        
        ENUM_Packet_ID=pc.getc();
        
        for(i=0; i<2; i++){
            UINT16_PacketCounter[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_Timestamp[i]=pc.getc();
        }        
        
        for(i=0; i<128; i++){
            vUNIT32_PortAnalogValue[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_AnalogMask[i]=pc.getc();
        }
        
        for(i=0; i<4; i++){
            UINT32_CRC[i]=pc.getc();
        }
        
        myled = 1;      
        
        setport();
        
        TGP_ANALOG_IN_ANS();
}


void TGP_ANALOG_IN_ANS()
{
    for(i=0; i<4; i++){
            pc.printf("%c",packetsize[i]);
    }
        
    pc.printf("%c",ENUM_Packet_ID+1);
    
    for(i=0; i<2; i++){
            pc.printf("%c",UINT16_PacketCounter[i]);
        }
        
    for(i=0; i<4; i++){
            pc.printf("%c",UINT32_Timestamp[i]);
        }
        
    
    for(i=0; i<4; i++){
            pc.printf("%c",crc[i]);
    }
    
    myled=0;
}

void setport()
{
    for ( size_t i = 0; i < 4; i++ ) 
    {
        n += vUNIT32_PortAnalogValue[i] << 8 * i;
    }
    
    out.write_u16(n);   
}
