
#include "mbed.h"
#include "drv8711v1.h"
#include "FastPWM.h"

#define volume      4.6
#define step_rev    25600
#define current_drv 1.5

#define MOSI    PA_7
#define MISO    PA_6
#define SCK     PA_5
#define CS      PA_4
#define STEP    PB_2
#define DIR     PB_1
#define RST     PB_10
#define NSLP    PB_11
#define STEP_MODE EIGHT_2
#define PWM     PA_8

DRV8711 drv(MOSI,MISO,SCK,CS,STEP,DIR,RST,NSLP);

Serial serial(PB_6,PB_7);
//Serial pc(USBTX,USBRX);
//Serial pc(PA_2,PA_3);
Ticker accelTime;
FastPWM step(PWM, -1);

char readSerial[64];
char inputCmd;
int fr;
bool steppingFlag = 0;
int pps = 1000;
float rpm = 0;
float nospm = 0;
float aDelay = 0;
float tDelay = 0;
bool accelFlag = 0;

void stepF();
void fr2delay();
void newDelay();
void accelPPS();
void readin();

int main() {
    
    serial.baud(115200);
    serial.printf("Initializing Driver...\n");
    
    drv.begin(STEP_MODE,volume,step_rev,current_drv);
    step.pulsewidth_us(0.0);
    serial.printf("Driver Initialization Completed...\n");
    
    while(1) {
        
        serial.printf("Ready for next input...\n");
        while(!serial.readable());
        serial.gets(readSerial,64);
        sscanf(readSerial,"%c",&inputCmd);
        
        if((inputCmd == 'M')||(inputCmd == 'm')){
        
            serial.printf("Input Flow Rate...\n");
            while(!serial.readable());
            serial.gets(readSerial, 64);
            sscanf(readSerial,"%i",&fr);
            serial.printf("Flow Rates: %i ml/min\n",fr);
            fr2delay();
            serial.printf("Enter anykey to start...\n");
            while(!serial.readable());
            serial.gets(readSerial,64);
            steppingFlag = 1;
            aDelay = 1000000/1000;
            step.period_us(aDelay);
            step.pulsewidth_us(aDelay/2);
            drv._nsleep = 1;
            //start stepping
            accelTime.attach(accelPPS, 0.005);
            while(steppingFlag != 0){
                if(serial.readable()){
                    inputCmd = serial.getc();
                    if((inputCmd == 'S')||(inputCmd == 's')){
                        step.pulsewidth_us(0.0);
                        drv._nsleep = 0;
                        serial.printf("Process Terminated...\n");
                    }
                }
            }
        }
    }
}

void accelPPS(){
    aDelay = aDelay - 2.5;
    if(aDelay <= tDelay){
        aDelay = tDelay;
        accelTime.detach();    
    }
    step.period_us(aDelay);
    step.pulsewidth_us(aDelay/2);
}

void fr2delay(){
    rpm = fr/4.6;
    serial.printf("RPM: %.2f\n",rpm);
    nospm = rpm*step_rev;
    serial.printf("NoSpM: %.2f\n",nospm);
    tDelay = (60000000/nospm);
    serial.printf("target Delay: %.2f\n",tDelay);    
}

