#ifndef TRACKER_H
#define TRACKER_H

#include "mbed.h"
#include "QEI.h"

#define STRAIGHT    0
#define CCW         1
#define CW          2
#define PI          3.14159265

class Tracker {
    public:
        Tracker(PinName _chA, PinName _chB, PinName _pot);
        void clear();
        void potSetup();
        void setDirection();
        void checkToStart();
        void calcDisplacement();
        
        float distance;
        
    private:
        QEI *wheel;
        PinName chA;
        PinName chB;
        AnalogIn pot;
        float pulseCount;
        float encoding;
        float circumference;
        float constant;

        

        float x;
        float y;

        float value;
        float turnAngle;
        float zeroAngle;

        int dir;

        float df;
        float db;
        float W;
        float R;
        float dispAngle;

};
#endif