/**
*   @file   Motor.h
*
*   @brief  Motor class implements API for controlling motors.
*
*   @author Terrabots Team
*
*/

#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"

/**
*   @class Motor
*
*   @brief  Interface for controlling the dump truck's motors
*/

class Motor {
    public:
        /**
        *   Constructor for the Motor object.
        *
        *   @param[in]  pwm     The PwmOut pin used for controlling speed.
        *   @param[in]  dir     The DigitalOut pin used for controlling direction.
        */
        Motor(PinName pwm, PinName dir);
        /**
        *   Command the motor to run at a desired speed
        *
        *   @param[in]  Val     The desired speed of type float.
        */
        void write(float Val);
        /**
        *   Read the speed of the motor
        */
        float read();
    private:
        PwmOut pwmPin;
        DigitalOut dirPin;
        float lastVal;
    
};

#endif