#include "mbed.h"

class Motor
{
protected:
  PwmOut pwmPin;
  DigitalOut dirPin;  
  float lastVal;
  
public:

  Motor(PinName pwm,PinName dir): pwmPin(pwm), dirPin(dir) 
  {
  }
   
  void write(float Val)
   {
      if (Val >= 0) {
        dirPin = 1;
        pwmPin = Val;
        }else {
            dirPin = 0;
            pwmPin = -1 * Val;
    }
    lastVal = Val;
 }
   
  float read()
   {
        return lastVal;
   }
   
};