/**
*   @file   IMU.h
*
*   @brief  Class for reading the accelerometer
*
*   @author Terrabots Team
*
*/

#ifndef IMU_H
#define IMU_H

#include "mbed.h"
#include "LSM9DS1.h"

class IMU {
    public:
        /**
        *   Constructor for the IMU
        */
        IMU();
        /**
        *   Track the angle of the truck bed
        */
        void trackBed();
        /**
        *   Track the angle of the truck as it moves
        */
        void trackHeading();

    private:
        LSM9DS1 *I;
        bool state;
        float ax01;
        float ay01;
        float az01;
        float ax0;
        float ay0;
        float az0;
        float ax;
        float ay;
        float az;
        float theta;
};

#endif