#ifndef MBED_DUMP_TRUCK_H
#define MBED_DUMP_TRUCK_H
 
#include "mbed.h"

Serial pc(USBTX, USBRX);

class DumpTruck {
public:
    DumpTruck(int truckId);
    void drive(); // Drive DC motors with a desired motor speed and distance
    void RotateTo();
    void BedDown(); 
    void BedUp();   
    void raiseTo();
    void LowerBed();
    void stop();
    void Calibrate();
    
    
protected:
    getBedAngle(); //Get data from Bed potentiometer, Hari is looking into the component for this
    getPivotAngle(double PivotAngle); //Get data from potentiometer
    SetPivotSpeed(double PivotSpeed); //Set arbitrary rotation of servo motor
    SetBedSpeed(); //Set arbitrary rotation of DC Motor
    float speed; //desired speed to drive the robot, a number between 0 and 1
    float distance; //input of desired distance to be traveled
    float setTruckSpeed(); // set user inputed truck speed
    float setTruckDistance(); //get user input for desired distance to be traveled
    bool GetBedUpperSwitch(); //Checks if bed is all the way up
    bool GetBedLowerSwitch(); //Checks if bed is all the way down
    bool SwitchState; //Switch state variable for Up and down bed functions
    float DesiredPivotAngle; // User Input of desired angle for the bed to be pivoted
    float DesiredBedAngle; //User Input of desired bed angle to be raised.
    float BedSpeed; //User input of desired speed for the dump truck's bed to rotate
    float PivotSpeed; //User input of desired speed for the dump truck to pivot its back at
    int truckNumber;
    bool isCalibrated;// returns 0 and 1 to check if the robot has been calibrated
};

#endif