#include "DumpTruck.h"

DumpTruck::DumpTruck(int truckId) : truckNumber(truckId) {
    truckNumber = truckId;
}

PwmOut DrivePin(p22);
DigitalOut DirPin(p29);

void Calibrate(){}

void DumpTruck::drive() {
    // get desired distance and speed
    distance = setTruckDistance();
    speed = setTruckSpeed();
    // terminal confirmation of distance and speed
    pc.printf("Truck will drive a distance of %f at a speed of %f",distance,speed);
    
    // insert while loop here which relates to distance travelled
    
    // if the speed is greater than zero, go forward at specified speed
    if (speed >= 0) {
    DirPin = 1;
    DrivePin = speed;
    } // else, go backwards at specified speed  
    else {
    DirPin = 0;
    DrivePin = -1 * speed;
    }
    // stop motors
    stop();
    // calibrate motors
    Calibrate();
}

float DumpTruck::setTruckDistance(){
    // terminal prompt for distance
    pc.printf("Please enter the truck distance:");
    // sets return value to given value
    float input = pc.getc();
    // returns value
    return input;
    }

float DumpTruck::setTruckSpeed(){
    // terminal prompt for speed
    pc.printf("Please enter the truck speed:");
    // sets return value to given value
    float input = pc.getc();
    // returns value
    return input;
    }
    
void DumpTruck::stop(){
    pc.printf("Truck will now stop.");
    //stop motors
    DrivePin = 0;
    }

void DumpTruck::RotateTo() {  
    pc.printf("Desired Angle: ");
    DesiredPivotAngle = pc.getc();
    float CurrentPivotAngle =  getPivotAngle();
    Difference = DesiredPivotAngle-CurrentPivotAngle;
    if (Difference > limit)
    {
        PivotSpeed = setPivotSpeed();
        pc.printf("Rotating to %s /n", DesiredPivotAngle);
        //Drive Motors
        }
    else
    {stop()}
    
}    

void DumpTruck::BedDown() {
     SwitchState = bool GetBedUpperSwitch();
     if SwitchState
     {return 0;}
     else

     while(SwitchState == 0)
     {
         //driveMotor
         }
         calibrate();
    }
void DumpTruck::LowerBed() {
    SwitchState = bool GetLowerUpperSwitch();
     if SwitchState
     {return 0;}
     else

     while(SwitchState == 0)
     {
         //driveMotor
         }
         calibrate();
    }
}
void DumpTruck::raiseTo(int angle) {
      pc.printf("Desired Angle: ");
    DesiredBedAngle = pc.getc();
    float CurrentBedAngle =  getBedAngle();
    Difference = DesiredBedAngle-CurrentBedAngle;
    if (Difference > limit)
    {
        BedSpeed = setBedSpeed();
        pc.printf("Rotating to %s /n", DesiredBedAngle);
        //Drive Motors
        }
    else
    {stop()}
}

float DumpTruck::getPivotAngle(){
    float input = AnalogIn(x);
    return input
    }
float DumpTruck::setPivotSpeed(){
     pc.printf("Please enter the Pivot speed /n");
    float input = pc.getc();
    return input;
    }

float DumpTruck::setBedSpeed(){
    pc.printf("Please enter the Bed speed /n");
    float input = pc.getc();
    return input;
    }
float DumpTruck::getBedAngle(){
    float input = AnalogIn(x); // data from potentiometer
    return input;
    }
    

