/**
*   @file   DumpTruck.h
*
*   @brief  DumpTruck class integrates multiple sensors into one API.
*
*   @author Terrabots Team
*
*/

#ifndef MBED_DUMP_TRUCK_H
#define MBED_DUMP_TRUCK_H

#include "mbed.h"
#include "Tracker.h"
//#include "IMU.h"
#include "Motor.h"
#include "nRF24L01P.h" //Transceiver library
#include "SRF05.h"
#include "LSM9DS1.h"

//using strings to process commands
#include <string> 
#include <stdio.h>
using namespace std;

#define TRANSFER_SIZE   8

// ADD SWITCHES & ULTRASONIC SENSOR implementation

/**
*   @class DumpTruck
*
*   @brief  Interface for controlling a Dump truck.
*/

class DumpTruck {
public:
    /**
    *   Constructor for the Tracker object.
    *
    *   @param[in]  truckId     The dump truck's identifier
    */
    DumpTruck(int truckId);

    /*
    *   Process command
    */
    void processCommand();

    /*
    *   Send not acknowledge
    */

    void sendNack();

    /*
    *   Send acknowledge
    */

    void sendAck();
    
    /*
    *   Initialize transceiver.
    */
    void startComms();
    
    /*
    *   Receive a command from base station.
    */
    void getCommand();
    
    /*
    *   Send important data back to the base station.
    */
    void reportData();

    // motor functions
    /*
    *   Drive a certain distance at a desired speed.
    */
    void driveDistance(float speed, float distance);// frontMotor
    /*
    *   Drive at a desired speed.
    */
    void drive(float speed);
    /*
    *   Turn the rear wheels a certain angle.
    */
    void turn(float angle);                 // turnMotor
    /*
    *   Move the dump truck's bed up/down a certain angle.
    */
    void moveBed(bool upper, bool lower, float angle);  // bedMotor
    /*
    *   Stop driving.
    */
    void stopDrive();                            // all Motors
    
    /*
    *   Stop turning.
    */
    void stopTurn();                            // all Motors

    /*
    *   Stop bed.
    */
    void stopBed();                            // all Motors

    // ultrasonic functions
    /*
    *   Read from the ultrasonic sensor and determine the dump truck's
    *   proximity from objects.
    */
    bool detect();                          // returns bool for object too close
    
    int txDataCnt;
    int rxDataCnt;
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    char acked[TRANSFER_SIZE];
    char nacked[TRANSFER_SIZE]; 
    bool received;


protected:
    Tracker *track;
    //IMU *bed;
    Motor *frontMotor;
    Motor *turnMotor;
    Motor *bedMotor;
    nRF24L01P *nrf; //Transceiver *nrf;
    SRF05 *srf;
    LSM9DS1 *IMU;

    // add direct control for motor, switch, and ultrasonic sensor.

    int truckNumber;

    // motor variables
    float speed;                            // drive
    float distance;                         // drive
    float startDist;                        // drive
    float curDist;                          // drive
    float potAngle;                         // turn
    float bedAngle;                         // bed

    // bed-specific variables
    bool switchState;   // BusIn the two limit switches
    float ax0;
    float ay0;
    float az0;
    float ax;
    float ay;
    float az;

    // ultrasonic-specific variables
    bool tooClose;
    float proximity;
    
    /*int txDataCnt;
    int rxDataCnt;
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    bool received;*/
};
#endif
