#include "mbed.h"
#include "nRF24L01P.h"
#include <iostream>
#include <string>

#define TRANSFER_SIZE   8

Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE], acked[TRANSFER_SIZE], 
    nacked[TRANSFER_SIZE];
bool ack = false;
int txDataCnt = 0;
int rxDataCnt = 0;

void waitForAck() {
    //RECEIVE ACK
    if (my_nrf24l01p.readable()) {
        // ...read the data into the receive buffer
        rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof(rxData));
        // match with ack array
        if(strcmp(rxData, acked)==-1) {
            pc.printf("ACK\n\r");
            ack = true;
        } else {
            pc.printf("NACK\n\r");
            ack = false;
        }
        rxDataCnt = 0;
        // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
        myled2 = !myled2;
    }
}

void checkValid() {
    waitForAck();   //other code has SWITCH statement
    if(ack) {//if valid, wait til next ack
        pc.printf("valid, please wait to send again\n\r");
        ack = false;
        while(!ack) {
            waitForAck();
        }
        pc.printf("ready to send again\r\n");
    } else {//if invalid
        pc.printf("invalid command, send another\n\r");
    }   
}

void send() {
    //SEND
    // If we've received anything over the host serial link...
    if (pc.readable()) {
        // ...add it to the transmit buffer
        txData[txDataCnt++] = pc.getc();
        // If the transmit buffer is full
        if (txDataCnt >= sizeof(txData)) {
            // Send the transmitbuffer via the nRF24L01+
            my_nrf24l01p.write(NRF24L01P_PIPE_P0, txData, txDataCnt);
            txDataCnt = 0;
            pc.printf("Sent command\n\r");
            
            //wait for valid confirmation
            checkValid();
        }
        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        myled1 = !myled1;
    }
}

int main() {
    //initialize the arrays recognized as ACK and NACK
    for(int i = 0; i < TRANSFER_SIZE; i++) {
        acked[i] = '0';
        nacked[i] = '1';
    }
    my_nrf24l01p.powerUp();
    // Display the (default) setup of the nRF24L01+ chip
    printf("\n\r--------\r\n");
    printf("BASE STATION\r\n");
    printf("Begin communications...\r\n");
    printf("--------\r\n");
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {
        if(!ack) {
            waitForAck();
        } else {
            send();
        }  
    }
}
