#include "mbed.h"
#include "ILI9341.h"
#include "math.h"        // Utile per operazione di rounding (?)   
#include "Arial_9.h"  // Font display
#include "SDFileSystem.h" //lib per SD


Serial bt(D8, D2);      // Bluetooth interface


// LEPTON
SPI lepton_spi(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut spi_cs(SPI_CS);
#define VOSPI_FRAME_SIZE (164)
uint8_t lepton_frame_packet[VOSPI_FRAME_SIZE];
uint16_t lepton_image[60][80];
int print_image_binary_state = -1;
int print_image_binary_i;
int print_image_binary_j;
int stop =0;
int save =1;
int cont=0;

// DISPLAY
ILI9341 tft (SPI_8, 40000000,PB_15, PB_14, PB_13, D7, D6, D9, "tft"); // SPI type, SPI speed, mosi, miso, sclk, cs, reset, dc; // ILI9341 driver //20MHz
char orient = 2;  // Orientazione del display

//Photo Button
InterruptIn button(PC_9);


//Micro SD
SDFileSystem sd(PC_12, PC_11, PC_10, D4, "sd");

// Variabili
int lost_frame_counter = 0;
int last_frame_number;
int frame_complete = 0;
int start_image = 0;
int need_resync = 0;
int last_crc;
int new_frame = 0;
int frame_counter = 0;
float minValue = 65535;
float maxValue = 0;
float max_p=0;
int8_t errore=0;
float T_image[60][80];
uint8_t matrix[60][240];
uint8_t matrix1[60][80];
float m1;
float n1;
int x1,y1,x2,y2;
float a0,a1,a2,a3;
float Out;
unsigned int color;

FATFS SDFatFs;//variabili per il salvataggio FAT del'immagine su microSD
FIL MyFile;
FRESULT res;


uint32_t  bytesread;

//Colorbar per salvataggio immagine
//const int colormap_rainbow[] = {1, 3, 74, 0, 3, 74, 0, 3, 75, 0, 3, 75, 0, 3, 76, 0, 3, 76, 0, 3, 77, 0, 3, 79, 0, 3, 82, 0, 5, 85, 0, 7, 88, 0, 10, 91, 0, 14, 94, 0, 19, 98, 0, 22, 100, 0, 25, 103, 0, 28, 106, 0, 32, 109, 0, 35, 112, 0, 38, 116, 0, 40, 119, 0, 42, 123, 0, 45, 128, 0, 49, 133, 0, 50, 134, 0, 51, 136, 0, 52, 137, 0, 53, 139, 0, 54, 142, 0, 55, 144, 0, 56, 145, 0, 58, 149, 0, 61, 154, 0, 63, 156, 0, 65, 159, 0, 66, 161, 0, 68, 164, 0, 69, 167, 0, 71, 170, 0, 73, 174, 0, 75, 179, 0, 76, 181, 0, 78, 184, 0, 79, 187, 0, 80, 188, 0, 81, 190, 0, 84, 194, 0, 87, 198, 0, 88, 200, 0, 90, 203, 0, 92, 205, 0, 94, 207, 0, 94, 208, 0, 95, 209, 0, 96, 210, 0, 97, 211, 0, 99, 214, 0, 102, 217, 0, 103, 218, 0, 104, 219, 0, 105, 220, 0, 107, 221, 0, 109, 223, 0, 111, 223, 0, 113, 223, 0, 115, 222, 0, 117, 221, 0, 118, 220, 1, 120, 219, 1, 122, 217, 2, 124, 216, 2, 126, 214, 3, 129, 212, 3, 131, 207, 4, 132, 205, 4, 133, 202, 4, 134, 197, 5, 136, 192, 6, 138, 185, 7, 141, 178, 8, 142, 172, 10, 144, 166, 10, 144, 162, 11, 145, 158, 12, 146, 153, 13, 147, 149, 15, 149, 140, 17, 151, 132, 22, 153, 120, 25, 154, 115, 28, 156, 109, 34, 158, 101, 40, 160, 94, 45, 162, 86, 51, 164, 79, 59, 167, 69, 67, 171, 60, 72, 173, 54, 78, 175, 48, 83, 177, 43, 89, 179, 39, 93, 181, 35, 98, 183, 31, 105, 185, 26, 109, 187, 23, 113, 188, 21, 118, 189, 19, 123, 191, 17, 128, 193, 14, 134, 195, 12, 138, 196, 10, 142, 197, 8, 146, 198, 6, 151, 200, 5, 155, 201, 4, 160, 203, 3, 164, 204, 2, 169, 205, 2, 173, 206, 1, 175, 207, 1, 178, 207, 1, 184, 208, 0, 190, 210, 0, 193, 211, 0, 196, 212, 0, 199, 212, 0, 202, 213, 1, 207, 214, 2, 212, 215, 3, 215, 214, 3, 218, 214, 3, 220, 213, 3, 222, 213, 4, 224, 212, 4, 225, 212, 5, 226, 212, 5, 229, 211, 5, 232, 211, 6, 232, 211, 6, 233, 211, 6, 234, 210, 6, 235, 210, 7, 236, 209, 7, 237, 208, 8, 239, 206, 8, 241, 204, 9, 242, 203, 9, 244, 202, 10, 244, 201, 10, 245, 200, 10, 245, 199, 11, 246, 198, 11, 247, 197, 12, 248, 194, 13, 249, 191, 14, 250, 189, 14, 251, 187, 15, 251, 185, 16, 252, 183, 17, 252, 178, 18, 253, 174, 19, 253, 171, 19, 254, 168, 20, 254, 165, 21, 254, 164, 21, 255, 163, 22, 255, 161, 22, 255, 159, 23, 255, 157, 23, 255, 155, 24, 255, 149, 25, 255, 143, 27, 255, 139, 28, 255, 135, 30, 255, 131, 31, 255, 127, 32, 255, 118, 34, 255, 110, 36, 255, 104, 37, 255, 101, 38, 255, 99, 39, 255, 93, 40, 255, 88, 42, 254, 82, 43, 254, 77, 45, 254, 69, 47, 254, 62, 49, 253, 57, 50, 253, 53, 52, 252, 49, 53, 252, 45, 55, 251, 39, 57, 251, 33, 59, 251, 32, 60, 251, 31, 60, 251, 30, 61, 251, 29, 61, 251, 28, 62, 250, 27, 63, 250, 27, 65, 249, 26, 66, 249, 26, 68, 248, 25, 70, 248, 24, 73, 247, 24, 75, 247, 25, 77, 247, 25, 79, 247, 26, 81, 247, 32, 83, 247, 35, 85, 247, 38, 86, 247, 42, 88, 247, 46, 90, 247, 50, 92, 248, 55, 94, 248, 59, 96, 248, 64, 98, 248, 72, 101, 249, 81, 104, 249, 87, 106, 250, 93, 108, 250, 95, 109, 250, 98, 110, 250, 100, 111, 251, 101, 112, 251, 102, 113, 251, 109, 117, 252, 116, 121, 252, 121, 123, 253, 126, 126, 253, 130, 128, 254, 135, 131, 254, 139, 133, 254, 144, 136, 254, 151, 140, 255, 158, 144, 255, 163, 146, 255, 168, 149, 255, 173, 152, 255, 176, 153, 255, 178, 155, 255, 184, 160, 255, 191, 165, 255, 195, 168, 255, 199, 172, 255, 203, 175, 255, 207, 179, 255, 211, 182, 255, 216, 185, 255, 218, 190, 255, 220, 196, 255, 222, 200, 255, 225, 202, 255, 227, 204, 255, 230, 206, 255, 233, 208};
//const int colormap_grayscale[] = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 21, 22, 22, 22, 23, 23, 23, 24, 24, 24, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 48, 49, 49, 49, 50, 50, 50, 51, 51, 51, 52, 52, 52, 53, 53, 53, 54, 54, 54, 55, 55, 55, 56, 56, 56, 57, 57, 57, 58, 58, 58, 59, 59, 59, 60, 60, 60, 61, 61, 61, 62, 62, 62, 63, 63, 63, 64, 64, 64, 65, 65, 65, 66, 66, 66, 67, 67, 67, 68, 68, 68, 69, 69, 69, 70, 70, 70, 71, 71, 71, 72, 72, 72, 73, 73, 73, 74, 74, 74, 75, 75, 75, 76, 76, 76, 77, 77, 77, 78, 78, 78, 79, 79, 79, 80, 80, 80, 81, 81, 81, 82, 82, 82, 83, 83, 83, 84, 84, 84, 85, 85, 85, 86, 86, 86, 87, 87, 87, 88, 88, 88, 89, 89, 89, 90, 90, 90, 91, 91, 91, 92, 92, 92, 93, 93, 93, 94, 94, 94, 95, 95, 95, 96, 96, 96, 97, 97, 97, 98, 98, 98, 99, 99, 99, 100, 100, 100, 101, 101, 101, 102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107, 107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113, 113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118, 119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124, 124, 125, 125, 125, 126, 126, 126, 127, 127, 127, 128, 128, 128, 129, 129, 129, 130, 130, 130, 131, 131, 131, 132, 132, 132, 133, 133, 133, 134, 134, 134, 135, 135, 135, 136, 136, 136, 137, 137, 137, 138, 138, 138, 139, 139, 139, 140, 140, 140, 141, 141, 141, 142, 142, 142, 143, 143, 143, 144, 144, 144, 145, 145, 145, 146, 146, 146, 147, 147, 147, 148, 148, 148, 149, 149, 149, 150, 150, 150, 151, 151, 151, 152, 152, 152, 153, 153, 153, 154, 154, 154, 155, 155, 155, 156, 156, 156, 157, 157, 157, 158, 158, 158, 159, 159, 159, 160, 160, 160, 161, 161, 161, 162, 162, 162, 163, 163, 163, 164, 164, 164, 165, 165, 165, 166, 166, 166, 167, 167, 167, 168, 168, 168, 169, 169, 169, 170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 173, 174, 174, 174, 175, 175, 175, 176, 176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 179, 180, 180, 180, 181, 181, 181, 182, 182, 182, 183, 183, 183, 184, 184, 184, 185, 185, 185, 186, 186, 186, 187, 187, 187, 188, 188, 188, 189, 189, 189, 190, 190, 190, 191, 191, 191, 192, 192, 192, 193, 193, 193, 194, 194, 194, 195, 195, 195, 196, 196, 196, 197, 197, 197, 198, 198, 198, 199, 199, 199, 200, 200, 200, 201, 201, 201, 202, 202, 202, 203, 203, 203, 204, 204, 204, 205, 205, 205, 206, 206, 206, 207, 207, 207, 208, 208, 208, 209, 209, 209, 210, 210, 210, 211, 211, 211, 212, 212, 212, 213, 213, 213, 214, 214, 214, 215, 215, 215, 216, 216, 216, 217, 217, 217, 218, 218, 218, 219, 219, 219, 220, 220, 220, 221, 221, 221, 222, 222, 222, 223, 223, 223, 224, 224, 224, 225, 225, 225, 226, 226, 226, 227, 227, 227, 228, 228, 228, 229, 229, 229, 230, 230, 230, 231, 231, 231, 232, 232, 232, 233, 233, 233, 234, 234, 234, 235, 235, 235, 236, 236, 236, 237, 237, 237, 238, 238, 238, 239, 239, 239, 240, 240, 240, 241, 241, 241, 242, 242, 242, 243, 243, 243, 244, 244, 244, 245, 245, 245, 246, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, 250, 250, 250, 251, 251, 251, 252, 252, 252, 253, 253, 253, 254, 254, 254, 255, 255, 255};
//const int colormap_ironblack[] = {255, 255, 255, 253, 253, 253, 251, 251, 251, 249, 249, 249, 247, 247, 247, 245, 245, 245, 243, 243, 243, 241, 241, 241, 239, 239, 239, 237, 237, 237, 235, 235, 235, 233, 233, 233, 231, 231, 231, 229, 229, 229, 227, 227, 227, 225, 225, 225, 223, 223, 223, 221, 221, 221, 219, 219, 219, 217, 217, 217, 215, 215, 215, 213, 213, 213, 211, 211, 211, 209, 209, 209, 207, 207, 207, 205, 205, 205, 203, 203, 203, 201, 201, 201, 199, 199, 199, 197, 197, 197, 195, 195, 195, 193, 193, 193, 191, 191, 191, 189, 189, 189, 187, 187, 187, 185, 185, 185, 183, 183, 183, 181, 181, 181, 179, 179, 179, 177, 177, 177, 175, 175, 175, 173, 173, 173, 171, 171, 171, 169, 169, 169, 167, 167, 167, 165, 165, 165, 163, 163, 163, 161, 161, 161, 159, 159, 159, 157, 157, 157, 155, 155, 155, 153, 153, 153, 151, 151, 151, 149, 149, 149, 147, 147, 147, 145, 145, 145, 143, 143, 143, 141, 141, 141, 139, 139, 139, 137, 137, 137, 135, 135, 135, 133, 133, 133, 131, 131, 131, 129, 129, 129, 126, 126, 126, 124, 124, 124, 122, 122, 122, 120, 120, 120, 118, 118, 118, 116, 116, 116, 114, 114, 114, 112, 112, 112, 110, 110, 110, 108, 108, 108, 106, 106, 106, 104, 104, 104, 102, 102, 102, 100, 100, 100, 98, 98, 98, 96, 96, 96, 94, 94, 94, 92, 92, 92, 90, 90, 90, 88, 88, 88, 86, 86, 86, 84, 84, 84, 82, 82, 82, 80, 80, 80, 78, 78, 78, 76, 76, 76, 74, 74, 74, 72, 72, 72, 70, 70, 70, 68, 68, 68, 66, 66, 66, 64, 64, 64, 62, 62, 62, 60, 60, 60, 58, 58, 58, 56, 56, 56, 54, 54, 54, 52, 52, 52, 50, 50, 50, 48, 48, 48, 46, 46, 46, 44, 44, 44, 42, 42, 42, 40, 40, 40, 38, 38, 38, 36, 36, 36, 34, 34, 34, 32, 32, 32, 30, 30, 30, 28, 28, 28, 26, 26, 26, 24, 24, 24, 22, 22, 22, 20, 20, 20, 18, 18, 18, 16, 16, 16, 14, 14, 14, 12, 12, 12, 10, 10, 10, 8, 8, 8, 6, 6, 6, 4, 4, 4, 2, 2, 2, 0, 0, 0, 0, 0, 9, 2, 0, 16, 4, 0, 24, 6, 0, 31, 8, 0, 38, 10, 0, 45, 12, 0, 53, 14, 0, 60, 17, 0, 67, 19, 0, 74, 21, 0, 82, 23, 0, 89, 25, 0, 96, 27, 0, 103, 29, 0, 111, 31, 0, 118, 36, 0, 120, 41, 0, 121, 46, 0, 122, 51, 0, 123, 56, 0, 124, 61, 0, 125, 66, 0, 126, 71, 0, 127, 76, 1, 128, 81, 1, 129, 86, 1, 130, 91, 1, 131, 96, 1, 132, 101, 1, 133, 106, 1, 134, 111, 1, 135, 116, 1, 136, 121, 1, 136, 125, 2, 137, 130, 2, 137, 135, 3, 137, 139, 3, 138, 144, 3, 138, 149, 4, 138, 153, 4, 139, 158, 5, 139, 163, 5, 139, 167, 5, 140, 172, 6, 140, 177, 6, 140, 181, 7, 141, 186, 7, 141, 189, 10, 137, 191, 13, 132, 194, 16, 127, 196, 19, 121, 198, 22, 116, 200, 25, 111, 203, 28, 106, 205, 31, 101, 207, 34, 95, 209, 37, 90, 212, 40, 85, 214, 43, 80, 216, 46, 75, 218, 49, 69, 221, 52, 64, 223, 55, 59, 224, 57, 49, 225, 60, 47, 226, 64, 44, 227, 67, 42, 228, 71, 39, 229, 74, 37, 230, 78, 34, 231, 81, 32, 231, 85, 29, 232, 88, 27, 233, 92, 24, 234, 95, 22, 235, 99, 19, 236, 102, 17, 237, 106, 14, 238, 109, 12, 239, 112, 12, 240, 116, 12, 240, 119, 12, 241, 123, 12, 241, 127, 12, 242, 130, 12, 242, 134, 12, 243, 138, 12, 243, 141, 13, 244, 145, 13, 244, 149, 13, 245, 152, 13, 245, 156, 13, 246, 160, 13, 246, 163, 13, 247, 167, 13, 247, 171, 13, 248, 175, 14, 248, 178, 15, 249, 182, 16, 249, 185, 18, 250, 189, 19, 250, 192, 20, 251, 196, 21, 251, 199, 22, 252, 203, 23, 252, 206, 24, 253, 210, 25, 253, 213, 27, 254, 217, 28, 254, 220, 29, 255, 224, 30, 255, 227, 39, 255, 229, 53, 255, 231, 67, 255, 233, 81, 255, 234, 95, 255, 236, 109, 255, 238, 123, 255, 240, 137, 255, 242, 151, 255, 244, 165, 255, 246, 179, 255, 248, 193, 255, 249, 207, 255, 251, 221, 255, 253, 235, 255, 255, 24};

// Prototipi
static void print_image_binary_background(void);
void transfer(void);
void SettaPixel(float value, int k,int s,float div,float minValue,float maxValue);
void draw_colorbar(void);
void Scale(float div,float min);
void push_button(void);
void data_save(uint16_t lepton_image [60][80]);
void matrix_save(uint8_t matrix [60][240],uint8_t value, int y, int k);
void save_SD(uint8_t matrix[60][240]);
void calcola(void);
void Colormap(float value, float div);


int main()
{
    tft.set_orientation(orient);
    bt.baud(115200);
    lepton_spi.format(8,3);
    lepton_spi.frequency(20000000); //20MHz
    spi_cs = 1;
    spi_cs = 0;
    spi_cs = 1;
    wait_ms(185);
    draw_colorbar();

    while(1) {
        spi_cs = 1;
        spi_cs = 0;
        spi_cs = 1;

        while(save==1) {
            button.fall(&push_button);
        }



        while(stop==0) {

            transfer(); // Recupero riga per riga l'immagine dalla LEPTON

        }

        stop=0;
        spi_cs = 1;
        spi_cs = 0;
        spi_cs = 1;
        //pc.printf("Fine1");
        // Converto l'immagine in temperatura (°C)
        for (int y =0; y < 60; y++) {
            for (int x = 0; x < 80; x++) {
                float v=lepton_image[y][x]/100;
                T_image[y][x]=floor(v);
                T_image[y][x]=T_image[y][x]-273;
            }
        }

        minValue = 65535;
        maxValue = 0;

        // Ricerca MAX e MIN nell'immagine
        for (int y =0; y < 60; y++) {
            for (int x = 0; x < 80; x++) {
                if (T_image[y][x] > maxValue) {
                    maxValue = T_image[y][x];
                }
                if (T_image[y][x] < minValue) {
                    minValue = T_image[y][x];
                }
            }
        }

        if(maxValue<(80+max_p)) {

            max_p=maxValue;
            //bt.putc(minValue);
            //bt.putc(maxValue);
            float v; // delta discretizzazione dei colori
            v=(maxValue-minValue)/120;
            //wait_ms(50);

            wait_ms(2);
            // Scrive l'immagine sul display a blocchi di 3x3
            tft.set_orientation(orient);
            tft.FastWindow(true);
            for (int m=0; m<177; m=m+3) {
                for (int n=0; n<237; n=n+3) {
                    m1=1.0/3*m;
                    n1=1.0/3*n;
                    x1=m1;
                    x2=m1+1;
                    y1=n1;
                    y2=n1+1;
                    calcola();

                    for(int i=m; i<m+3; i++) {
                        for(int j=n; j<n+3; j++) {
                            Out=a0+a1*m1+a2*n1+a3*m1*n1;
                            SettaPixel(Out,i,237-j,v,minValue,maxValue);
                            m1=m1+1.0/3;
                        }
                        m1=1.0/3*m;
                        n1=n1+1.0/3;
                    }

                }
            }
            tft.FastWindow(false);


            Scale(v,minValue);



            print_image_binary_background();
            bt.printf("\n\r");
            //bt.printf("ok");
            data_save(lepton_image);
            save_SD(matrix);
            save=1;

        }
        // bt.printf("Fine");
        //}
        else {
            save=1;
            //lepton_spi.format(8,3);
            //lepton_spi.frequency(20000000); //20MHz
            //spi_cs = 1;
            // spi_cs = 0;
            //spi_cs = 1;
            //wait_ms(800);
        }


    }

}

// **************** Implementazione funzioni ******************

// Download tramite SPI di una riga dell'immagine dalla LEPTON al Micro
void transfer(void)
{
    int i;
    int frame_number;

    spi_cs = 0;
    // Download dati RAW
    for(i=0; i<VOSPI_FRAME_SIZE; i++) {
        lepton_frame_packet[i] = lepton_spi.write(0x00);
    }
    spi_cs = 1;
    if(((lepton_frame_packet[0]&0xf) != 0x0f)) {
        if(lepton_frame_packet[1] == 0  ) {
            if(last_crc != (lepton_frame_packet[3]<<8 | lepton_frame_packet[4])) {
                new_frame = 1;
            }
            last_crc = lepton_frame_packet[3]<<8 | lepton_frame_packet[4];
        }
        frame_number = lepton_frame_packet[1];
        // Conversione dati RAW in matrice
        if(frame_number < 60 ) {
            lost_frame_counter = 0;
            if(print_image_binary_state == -1) {
                for(i=0; i<80; i++) {
                    lepton_image[frame_number][i] = (lepton_frame_packet[2*i+4] << 8 | lepton_frame_packet[2*i+5]);
                }
            }
        } else {
            lost_frame_counter++;
        }
        if( frame_number == 59) {
            frame_complete = 1;
            last_frame_number = 0;
        }
    } else {
        if(last_frame_number ==0) {
        }
    }
    lost_frame_counter++;
    if(lost_frame_counter>100) {
        need_resync = 1;
        lost_frame_counter = 0;
    }
    if(need_resync) {
        wait_ms(185);
        need_resync = 0;
    }
    if(frame_complete) {
        if(new_frame) {
            frame_counter++;
            {

                if(frame_counter%1 ==0) {
                    print_image_binary_state = -1;
                    stop=1;
                }
            }
            new_frame = 0;
        }
        frame_complete = 0;
    }
}

// Utile per inviare l'immagine tramite UART o BLE
static void print_image_binary_background(void)
{
    print_image_binary_i=0;
    print_image_binary_j=0;
    while(print_image_binary_i!=60) {
        while(bt.writeable() == 0);
        bt.putc((lepton_image[print_image_binary_i][print_image_binary_j]>>8)&0xff);
        while(bt.writeable() == 0);
        bt.putc(lepton_image[print_image_binary_i][print_image_binary_j]&0xff);
        print_image_binary_j++;
        if(print_image_binary_j>=80) {
            print_image_binary_j=0;
            print_image_binary_i++;
            if(print_image_binary_i>=60) {
                print_image_binary_state = -1;
                //pc.printf("fine...");
                //spi_cs=1;
                //stop=1;
            }
        }
        //stop=0; // Da eliminare se si riattiva il while
    }
}

// Conversione da grey a color e settaggio di un pixel
void SettaPixel(float value, int k,int s,float div,float minValue,float maxValue)
{



    if( value<=1*div+minValue ) {
        tft.pixel(k,s,color1);
    } else if(value>(1*div+minValue) &  value<=2*div+minValue ) {
        tft.pixel(k,s,color2);
    } else if(value>(2*div+minValue) &  value<=3*div+minValue ) {
        tft.pixel(k,s,color3);
    } else if(value>(3*div+minValue) &  value<=4*div+minValue ) {
        tft.pixel(k,s,color4);
    } else if(value>(4*div+minValue) &  value<=5*div+minValue ) {
        tft.pixel(k,s,color5);
    } else if(value>(5*div+minValue) &  value<=6*div+minValue ) {
        tft.pixel(k,s,color6);
    } else if(value>(6*div+minValue) &  value<=7*div+minValue ) {
        tft.pixel(k,s,color7);
    } else if(value>(7*div+minValue) &  value<=8*div+minValue ) {
        tft.pixel(k,s,color8);
    } else if(value>(8*div+minValue) &  value<=9*div+minValue ) {
        tft.pixel(k,s,color9);
    } else if(value>(9*div+minValue) &  value<=10*div+minValue ) {
        tft.pixel(k,s,color10);
    } else if(value>(10*div+minValue) &  value<=11*div+minValue ) {
        tft.pixel(k,s,color11);
    } else if(value>(11*div+minValue) &  value<=12*div+minValue ) {
        tft.pixel(k,s,color12);
    } else if(value>(12*div+minValue) &  value<=13*div+minValue ) {
        tft.pixel(k,s,color13);
    } else if(value>(13*div+minValue) &  value<=14*div+minValue ) {
        tft.pixel(k,s,color14);
    } else if(value>(14*div+minValue) &  value<=15*div+minValue ) {
        tft.pixel(k,s,color15);
    } else if(value>(15*div+minValue) &  value<=16*div+minValue ) {
        tft.pixel(k,s,color16);
    } else if(value>(16*div+minValue) &  value<=17*div+minValue ) {
        tft.pixel(k,s,color17);
    } else if(value>(17*div+minValue) &  value<=18*div+minValue ) {
        tft.pixel(k,s,color18);
    } else if(value>(18*div+minValue) &  value<=19*div+minValue ) {
        tft.pixel(k,s,color19);
    } else if(value>(19*div+minValue) &  value<=20*div+minValue ) {
        tft.pixel(k,s,color20);
    } else if(value>(20*div+minValue) &  value<=21*div+minValue ) {
        tft.pixel(k,s,color21);
    } else if(value>(21*div+minValue) &  value<=22*div+minValue ) {
        tft.pixel(k,s,color22);
    } else if(value>(22*div+minValue) &  value<=23*div+minValue ) {
        tft.pixel(k,s,color23);
    } else if(value>(23*div+minValue) &  value<=24*div+minValue ) {
        tft.pixel(k,s,color24);
    } else if(value>(24*div+minValue) &  value<=25*div+minValue ) {
        tft.pixel(k,s,color25);
    } else if(value>(25*div+minValue) &  value<=26*div+minValue ) {
        tft.pixel(k,s,color26);
    } else if(value>(26*div+minValue) &  value<=27*div+minValue ) {
        tft.pixel(k,s,color27);
    } else if(value>(27*div+minValue) &  value<=28*div+minValue ) {
        tft.pixel(k,s,color28);
    } else if(value>(28*div+minValue) &  value<=29*div+minValue ) {
        tft.pixel(k,s,color29);
    } else if(value>(29*div+minValue) &  value<=30*div+minValue ) {
        tft.pixel(k,s,color30);
    } else if(value>(30*div+minValue) &  value<=31*div+minValue ) {
        tft.pixel(k,s,color31);
    } else if(value>(31*div+minValue) &  value<=32*div+minValue ) {
        tft.pixel(k,s,color32);
    } else if(value>(32*div+minValue) &  value<=33*div+minValue ) {
        tft.pixel(k,s,color33);
    } else if(value>(33*div+minValue) &  value<=34*div+minValue ) {
        tft.pixel(k,s,color34);
    } else if(value>(34*div+minValue) &  value<=35*div+minValue ) {
        tft.pixel(k,s,color35);
    } else if(value>(35*div+minValue) &  value<=36*div+minValue ) {
        tft.pixel(k,s,color36);
    } else if(value>(36*div+minValue) &  value<=37*div+minValue ) {
        tft.pixel(k,s,color37);
    } else if(value>(37*div+minValue) &  value<=38*div+minValue ) {
        tft.pixel(k,s,color38);
    } else if(value>(38*div+minValue) &  value<=39*div+minValue ) {
        tft.pixel(k,s,color39);
    } else if(value>(39*div+minValue) &  value<=40*div+minValue ) {
        tft.pixel(k,s,color40);
    } else if(value>(40*div+minValue) &  value<=41*div+minValue ) {
        tft.pixel(k,s,color41);
    } else if(value>(41*div+minValue) &  value<=42*div+minValue ) {
        tft.pixel(k,s,color42);
    } else if(value>(42*div+minValue) &  value<=43*div+minValue ) {
        tft.pixel(k,s,color43);
    } else if(value>(43*div+minValue) &  value<=44*div+minValue ) {
        tft.pixel(k,s,color44);
    } else if(value>(44*div+minValue) &  value<=45*div+minValue ) {
        tft.pixel(k,s,color45);
    } else if(value>(45*div+minValue) &  value<=46*div+minValue ) {
        tft.pixel(k,s,color46);
    } else if(value>(46*div+minValue) &  value<=47*div+minValue ) {
        tft.pixel(k,s,color47);
    } else if(value>(47*div+minValue) &  value<=48*div+minValue ) {
        tft.pixel(k,s,color48);
    } else if(value>(48*div+minValue) &  value<=49*div+minValue ) {
        tft.pixel(k,s,color49);
    } else if(value>(49*div+minValue) &  value<=50*div+minValue ) {
        tft.pixel(k,s,color50);
    } else if(value>(50*div+minValue) &  value<=51*div+minValue ) {
        tft.pixel(k,s,color51);
    } else if(value>(51*div+minValue) &  value<=52*div+minValue ) {
        tft.pixel(k,s,color52);
    } else if(value>(52*div+minValue) &  value<=53*div+minValue ) {
        tft.pixel(k,s,color53);
    } else if(value>(53*div+minValue) &  value<=54*div+minValue ) {
        tft.pixel(k,s,color54);
    } else if(value>(54*div+minValue) &  value<=55*div+minValue ) {
        tft.pixel(k,s,color55);
    } else if(value>(55*div+minValue) &  value<=56*div+minValue ) {
        tft.pixel(k,s,color56);
    } else if(value>(56*div+minValue) &  value<=57*div+minValue ) {
        tft.pixel(k,s,color57);
    } else if(value>(57*div+minValue) &  value<=58*div+minValue ) {
        tft.pixel(k,s,color58);
    } else if(value>(58*div+minValue) &  value<=59*div+minValue ) {
        tft.pixel(k,s,color59);
    } else if(value>(59*div+minValue) &  value<=60*div+minValue ) {
        tft.pixel(k,s,color60);
    } else if(value>(60*div+minValue) &  value<=61*div+minValue ) {
        tft.pixel(k,s,color61);
    } else if(value>(61*div+minValue) &  value<=62*div+minValue ) {
        tft.pixel(k,s,color62);
    } else if(value>(62*div+minValue) &  value<=63*div+minValue ) {
        tft.pixel(k,s,color63);
    } else if(value>(63*div+minValue) &  value<=64*div+minValue ) {
        tft.pixel(k,s,color64);
    } else if(value>(64*div+minValue) &  value<=65*div+minValue ) {
        tft.pixel(k,s,color65);
    } else if(value>(65*div+minValue) &  value<=66*div+minValue ) {
        tft.pixel(k,s,color66);
    } else if(value>(66*div+minValue) &  value<=67*div+minValue ) {
        tft.pixel(k,s,color67);
    } else if(value>(67*div+minValue) &  value<=68*div+minValue ) {
        tft.pixel(k,s,color68);
    } else if(value>(68*div+minValue) &  value<=69*div+minValue ) {
        tft.pixel(k,s,color69);
    } else if(value>(69*div+minValue) &  value<=70*div+minValue ) {
        tft.pixel(k,s,color70);
    } else if(value>(70*div+minValue) &  value<=71*div+minValue ) {
        tft.pixel(k,s,color71);
    } else if(value>(71*div+minValue) &  value<=72*div+minValue ) {
        tft.pixel(k,s,color72);
    } else if(value>(72*div+minValue) &  value<=73*div+minValue ) {
        tft.pixel(k,s,color73);
    } else if(value>(73*div+minValue) &  value<=74*div+minValue ) {
        tft.pixel(k,s,color74);
    } else if(value>(74*div+minValue) &  value<=75*div+minValue ) {
        tft.pixel(k,s,color75);
    } else if(value>(75*div+minValue) &  value<=76*div+minValue ) {
        tft.pixel(k,s,color76);
    } else if(value>(76*div+minValue) &  value<=77*div+minValue ) {
        tft.pixel(k,s,color77);
    } else if(value>(77*div+minValue) &  value<=78*div+minValue ) {
        tft.pixel(k,s,color78);
    } else if(value>(78*div+minValue) &  value<=79*div+minValue ) {
        tft.pixel(k,s,color79);
    } else if(value>(79*div+minValue) &  value<=80*div+minValue ) {
        tft.pixel(k,s,color80);
    } else if(value>(80*div+minValue) &  value<=81*div+minValue ) {
        tft.pixel(k,s,color81);
    } else if(value>(81*div+minValue) &  value<=82*div+minValue ) {
        tft.pixel(k,s,color82);
    } else if(value>(82*div+minValue) &  value<=83*div+minValue ) {
        tft.pixel(k,s,color83);
    } else if(value>(83*div+minValue) &  value<=84*div+minValue ) {
        tft.pixel(k,s,color84);
    } else if(value>(84*div+minValue) &  value<=85*div+minValue ) {
        tft.pixel(k,s,color85);
    } else if(value>(85*div+minValue) &  value<=86*div+minValue ) {
        tft.pixel(k,s,color86);
    } else if(value>(86*div+minValue) &  value<=87*div+minValue ) {
        tft.pixel(k,s,color87);
    } else if(value>(87*div+minValue) &  value<=88*div+minValue ) {
        tft.pixel(k,s,color88);
    } else if(value>(88*div+minValue) &  value<=89*div+minValue ) {
        tft.pixel(k,s,color89);
    } else if(value>(89*div+minValue) &  value<=90*div+minValue ) {
        tft.pixel(k,s,color90);
    } else if(value>(90*div+minValue) &  value<=91*div+minValue ) {
        tft.pixel(k,s,color91);
    } else if(value>(91*div+minValue) &  value<=92*div+minValue ) {
        tft.pixel(k,s,color92);
    } else if(value>(92*div+minValue) &  value<=93*div+minValue ) {
        tft.pixel(k,s,color93);
    } else if(value>(93*div+minValue) &  value<=94*div+minValue ) {
        tft.pixel(k,s,color94);
    } else if(value>(94*div+minValue) &  value<=95*div+minValue ) {
        tft.pixel(k,s,color95);
    } else if(value>(95*div+minValue) &  value<=96*div+minValue ) {
        tft.pixel(k,s,color96);
    } else if(value>(96*div+minValue) &  value<=97*div+minValue ) {
        tft.pixel(k,s,color97);
    } else if(value>(97*div+minValue) &  value<=98*div+minValue ) {
        tft.pixel(k,s,color98);
    } else if(value>(98*div+minValue) &  value<=99*div+minValue ) {
        tft.pixel(k,s,color99);
    } else if(value>(99*div+minValue) &  value<=100*div+minValue ) {
        tft.pixel(k,s,color100);
    } else if(value>(100*div+minValue) &  value<=101*div+minValue ) {
        tft.pixel(k,s,color101);
    } else if(value>(101*div+minValue) &  value<=102*div+minValue ) {
        tft.pixel(k,s,color102);
    } else if(value>(102*div+minValue) &  value<=103*div+minValue ) {
        tft.pixel(k,s,color103);
    } else if(value>(103*div+minValue) &  value<=104*div+minValue ) {
        tft.pixel(k,s,color104);
    } else if(value>(104*div+minValue) &  value<=105*div+minValue ) {
        tft.pixel(k,s,color105);
    } else if(value>(105*div+minValue) &  value<=106*div+minValue ) {
        tft.pixel(k,s,color106);
    } else if(value>(106*div+minValue) &  value<=107*div+minValue ) {
        tft.pixel(k,s,color107);
    } else if(value>(107*div+minValue) &  value<=108*div+minValue ) {
        tft.pixel(k,s,color108);
    } else if(value>(108*div+minValue) &  value<=109*div+minValue ) {
        tft.pixel(k,s,color109);
    } else if(value>(109*div+minValue) &  value<=110*div+minValue ) {
        tft.pixel(k,s,color110);
    } else if(value>(110*div+minValue) &  value<=111*div+minValue ) {
        tft.pixel(k,s,color111);
    } else if(value>(111*div+minValue) &  value<=112*div+minValue ) {
        tft.pixel(k,s,color112);
    } else if(value>(112*div+minValue) &  value<=113*div+minValue ) {
        tft.pixel(k,s,color113);
    } else if(value>(113*div+minValue) &  value<=114*div+minValue ) {
        tft.pixel(k,s,color114);
    } else if(value>(114*div+minValue) &  value<=115*div+minValue ) {
        tft.pixel(k,s,color115);
    } else if(value>(115*div+minValue) &  value<=116*div+minValue ) {
        tft.pixel(k,s,color116);
    } else if(value>(116*div+minValue) &  value<=117*div+minValue ) {
        tft.pixel(k,s,color117);
    } else if(value>(117*div+minValue) &  value<=118*div+minValue ) {
        tft.pixel(k,s,color118);
    } else if(value>(118*div+minValue) &  value<=119*div+minValue ) {
        tft.pixel(k,s,color119);
    } else if(value>(119*div+minValue)) {
        tft.pixel(k,s,color120);
    }
    tft.copy_to_lcd();
}

// Disegna la colorbar (Aggiungere etichette)
void draw_colorbar(void)
{
    tft.rect(1,290,180,320,White);
    tft.fillrect(177,291,179,318,color1);
    tft.fillrect(174,291,176,318,color3);
    tft.line(176,289,176,285,White);
    tft.fillrect(171,291,173,318,color5);
    tft.fillrect(168,291,170,318,color7);
    tft.fillrect(165,291,167,318,color9);
    tft.fillrect(162,291,164,318,color11);
    tft.fillrect(159,291,161,318,color13);
    tft.fillrect(156,291,158,318,color15);
    tft.line(161,289,161,285,White);
    tft.fillrect(153,291,155,318,color17);
    tft.fillrect(150,291,152,318,color19);
    tft.fillrect(147,291,149,318,color21);
    tft.fillrect(144,291,146,318,color23);
    tft.line(146,289,146,285,White);
    tft.fillrect(141,291,143,318,color25);
    tft.fillrect(138,291,140,318,color27);
    tft.fillrect(135,291,137,318,color29);
    tft.fillrect(132,291,134,318,color31);
    tft.line(131,289,131,285,White);
    tft.fillrect(129,291,131,318,color33);
    tft.fillrect(126,291,128,318,color35);
    tft.fillrect(123,291,125,318,color37);
    tft.fillrect(120,291,122,318,color39);
    tft.line(116,289,116,285,White);
    tft.fillrect(117,291,119,318,color41);
    tft.fillrect(114,291,116,318,color43);
    tft.fillrect(111,291,113,318,color45);
    tft.fillrect(108,291,110,318,color47);
    tft.fillrect(105,291,107,318,color49);
    tft.fillrect(102,291,104,318,color51);
    tft.line(101,289,101,285,White);
    tft.fillrect(99,291,101,318,color53);
    tft.fillrect(96,291,98,318,color55);
    tft.fillrect(93,291,95,318,color57);
    tft.fillrect(90,291,92,318,color59);
    tft.fillrect(87,291,89,318,color61);
    tft.line(86,289,86,285,White);
    tft.fillrect(84,291,86,318,color63);
    tft.fillrect(81,291,83,318,color65);
    tft.fillrect(78,291,80,318,color67);
    tft.fillrect(75,291,77,318,color69);
    tft.fillrect(72,291,74,318,color71);
    tft.line(71,289,71,285,White);
    tft.fillrect(69,291,71,318,color73);
    tft.fillrect(66,291,68,318,color75);
    tft.fillrect(63,291,65,318,color77);
    tft.fillrect(60,291,62,318,color79);
    tft.fillrect(57,291,59,318,color81);
    tft.line(56,289,56,285,White);
    tft.fillrect(54,291,56,318,color83);
    tft.fillrect(51,291,53,318,color85);
    tft.fillrect(48,291,50,318,color87);
    tft.fillrect(45,291,47,318,color89);
    tft.fillrect(42,291,44,318,color91);
    tft.line(41,289,41,285,White);
    tft.fillrect(39,291,41,318,color93);
    tft.fillrect(36,291,38,318,color95);
    tft.fillrect(33,291,35,318,color97);
    tft.fillrect(30,291,32,318,color99);
    tft.fillrect(27,291,29,318,color101);
    tft.line(26,289,26,285,White);
    tft.fillrect(24,291,26,318,color103);
    tft.fillrect(21,291,23,318,color105);
    tft.fillrect(18,291,20,318,color107);
    tft.fillrect(15,291,17,318,color109);
    tft.fillrect(12,291,14,318,color111);
    tft.line(11,289,11,285,White);
    tft.fillrect(9,291,11,318,color113);
    tft.fillrect(6,291,8,318,color115);
    tft.fillrect(2,291,5,318,color117);

    tft.copy_to_lcd();
}

//Setta i valori di temperatura corrispondenti ai colori della colorbar
void Scale(float div,float min)
{
    tft.set_font((unsigned char*) Arial_9);
    tft.set_orientation(1);
    tft.locate(35,6);
    tft.printf("%.2f",div*119+min);
    tft.locate(35,21);
    tft.printf("%.2f",div*111+min);
    tft.locate(35,36);
    tft.printf("%.2f",div*100+min);
    tft.locate(35,51);
    tft.printf("%.2f",div*89+min);
    tft.locate(35,66);
    tft.printf("%.2f",div*78+min);
    tft.locate(35,81);
    tft.printf("%.2f",div*67+min);
    tft.locate(35,96);
    tft.printf("%.2f",div*56+min);
    tft.locate(35,111);
    tft.printf("%.2f",div*45+min);
    tft.locate(35,126);
    tft.printf("%.2f",div*34+min);
    tft.locate(35,141);
    tft.printf("%.2f",div*23+min);
    tft.locate(35,156);
    tft.printf("%.2f",div*11+min);
    tft.locate(35,171);
    tft.printf("%.2f",div*1+min);
    tft.locate(100,190);
    tft.printf("Celsius Degree Scale");
}


//Funzione che rileva pressione Bottone
void push_button()
{
    save=!save;
}



//Funzione che estrapola i dati da salvare
void data_save(uint16_t lepton_image [60][80])
{
    // uint8_t minimo = 255;
    // uint8_t massimo = 0;

    //  for (int y =0; y < 60; y++) {
    //   for (int x = 0; x < 80; x++) {
    //     matrix1[y][x]=lepton_image[y][x]>>8;
    //   if (matrix1[y][x] > massimo) {
    //       massimo = matrix1[y][x];
    //   }
    //  if (matrix1[y][x] < minimo) {
    //       minimo = matrix1[y][x];
    //  }
    //}
    //}


    //bt.printf("ok");
    //int8_t diff = massimo - minimo;
    //float scale = (255 / diff);

    float v; // delta discretizzazione dei colori
    v=(maxValue-minValue)/59;


    int k;

    for (int y =0; y <60; y++) {
        k=0;
        //bt.printf("ok");
        for (int x = 0; x < 80; x++) {
            float value;
            value=T_image[y][x];
            Colormap(value,v);
            matrix_save(matrix,color,y,k);
            k=k+3;
        }
    }

    //bt.printf("Sono fuori dal for");
    //bt.printf("\n\r");
    //bt.printf("ok");
}



//Funzione che costruisce la matrice da slavare 60x240
void matrix_save(uint8_t matrix [60][240],uint8_t value,int y, int k)
{
    //const int *colormap = colormap_grayscale;
    matrix[y][k]=color;
    matrix[y][k+1]=color;
    matrix[y][k+2]=color;
}


//Funzione per il salvataggio su microSD
void save_SD(uint8_t matrix[60][240])
{




    int width=80;
    int height=60;

    unsigned long buf_stride = (((width * 4u) + 31u) & ~31u);
    unsigned long pic_size = buf_stride * height;
    f_mount(&SDFatFs, "", 0);

//header
    uint8_t file[14] = {
        'B','M', // magic
        0,0,0,0, // size in bytes
        0,0, // app data
        0,0, // app data
        54,0,0,0 // start of data offset
    };
    uint8_t info[40] = {
        40,0,0,0, // info hd size
        80,0,0,0, // width
        60,0,0,0, // heigth
        1,0, // number color planes
        24,0, // bits per pixel
        0,0,0,0, // compression is none
        (uint8_t)(pic_size),(uint8_t)(pic_size)>>8,(uint8_t)(pic_size)>>16,(uint8_t)(pic_size)>>18, // image bits size
        0,0,0,0, // horz resoluition in pixel / m
        0,0,0,0, // vert resolutions (0x03C3 = 96 dpi, 0x0B13 = 72 dpi)
        0,0,0,0, // #colors in pallete
        0,0,0,0, // #important colors
    };

    char data[60];
    int num_char;
    cont=cont+1;
    num_char = sprintf(data, "termo_image_%d.bmp", cont);

    res=f_open(&MyFile, data,   FA_CREATE_ALWAYS| FA_WRITE );
    while(res!= FR_OK) {
        res=f_open(&MyFile, data,   FA_CREATE_ALWAYS| FA_WRITE);
        if(res!= FR_OK) {
            bt.printf("Failed to open file\n");
        }
    }


    res=f_write(&MyFile, (uint8_t *)file, 14, &bytesread);
    if(res!= FR_OK) {
        bt.printf("Failed to write file (file)\n");
    }


    res=f_write(&MyFile, (uint8_t *)info, 40, &bytesread);
    if(res!= FR_OK) {
        bt.printf("Failed to write file (info)\n");
    }

    res=f_write(&MyFile, (uint8_t *)matrix,14400, &bytesread);
    if(res!= FR_OK) {
        bt.printf("Failed to write file (data)\n");
    }

    f_sync(&MyFile);
    f_close(&MyFile);
    f_mount(NULL, "", 0);
    bt.printf("HO FINITO DI SALVARE");


}



void calcola(void)
{
    a3=float(T_image[x2][y2]-T_image[x2][y2]-T_image[x1][y2]+T_image[x1][y1])/(-y1*(x2-x1)-x1*(y2-y1)+(x2*y2-x1*y1));
    a2=float(T_image[x1][y2]-T_image[x1][y1]-x1*(y2-y1)*a3)/((y2-y1));
    a1=float(T_image[x2][y1]-T_image[x1][y1]-y1*a3*(x2-x1))/(x2-x1);
    a0=T_image[x1][y1]-a1*x1-y1*a2-a3*x1*y1;
}

void Colormap(float value,float div)
{
    if(value<=(div+minValue)) {
        color=0;
    } else if(value>(1*div+minValue) &  value<=2*div+minValue ) {
        color=20;
    } else if(value>(2*div+minValue) &  value<=3*div+minValue ) {
        color=24;
    } else if(value>(3*div+minValue) &  value<=4*div+minValue ) {
        color=28;
    } else if(value>(4*div+minValue) &  value<=5*div+minValue ) {
        color=32;
    } else if(value>(5*div+minValue) &  value<=6*div+minValue ) {
        color=36;
    } else if(value>(6*div+minValue) &  value<=7*div+minValue ) {
        color=40;
    } else if(value>(7*div+minValue) &  value<=8*div+minValue ) {
        color=44;
    } else if(value>(8*div+minValue) &  value<=9*div+minValue ) {
        color=48;
    } else if(value>(9*div+minValue) &  value<=10*div+minValue ) {
        color=52;
    } else if(value>(10*div+minValue) &  value<=11*div+minValue ) {
        color=56;
    } else if(value>(11*div+minValue) &  value<=12*div+minValue ) {
        color=60;
    } else if(value>(12*div+minValue) &  value<=13*div+minValue ) {
        color=64;
    } else if(value>(13*div+minValue) &  value<=14*div+minValue ) {
        color=68;
    } else if(value>(14*div+minValue) &  value<=15*div+minValue ) {
        color=72;
    } else if(value>(15*div+minValue) &  value<=16*div+minValue ) {
        color=76;
    } else if(value>(16*div+minValue) &  value<=17*div+minValue ) {
        color=80;
    } else if(value>(17*div+minValue) &  value<=18*div+minValue ) {
        color=84;
    } else if(value>(18*div+minValue) &  value<=19*div+minValue ) {
        color=88;
    } else if(value>(19*div+minValue) &  value<=20*div+minValue ) {
        color=92;
    } else if(value>(20*div+minValue) &  value<=21*div+minValue ) {
        color=96;
    } else if(value>(21*div+minValue) &  value<=22*div+minValue ) {
        color=100;
    } else if(value>(22*div+minValue) &  value<=23*div+minValue ) {
        color=104;
    } else if(value>(23*div+minValue) &  value<=24*div+minValue ) {
        color=108;
    } else if(value>(24*div+minValue) &  value<=25*div+minValue ) {
        color=112;
    } else if(value>(25*div+minValue) &  value<=26*div+minValue ) {
        color=116;
    } else if(value>(26*div+minValue) &  value<=27*div+minValue ) {
        color=120;
    } else if(value>(27*div+minValue) &  value<=28*div+minValue ) {
        color=124;
    } else if(value>(28*div+minValue) &  value<=29*div+minValue ) {
        color=128;
    } else if(value>(29*div+minValue) &  value<=30*div+minValue ) {
        color=132;
    } else if(value>(30*div+minValue) &  value<=31*div+minValue ) {
        color=136;
    } else if(value>(31*div+minValue) &  value<=32*div+minValue ) {
        color=140;
    } else if(value>(32*div+minValue) &  value<=33*div+minValue ) {
        color=144;
    } else if(value>(33*div+minValue) &  value<=34*div+minValue ) {
        color=148;
    } else if(value>(34*div+minValue) &  value<=35*div+minValue ) {
        color=152;
    } else if(value>(35*div+minValue) &  value<=36*div+minValue ) {
        color=156;
    } else if(value>(36*div+minValue) &  value<=37*div+minValue ) {
        color=160;
    } else if(value>(37*div+minValue) &  value<=38*div+minValue ) {
        color=164;
    } else if(value>(38*div+minValue) &  value<=39*div+minValue ) {
        color=168;
    } else if(value>(39*div+minValue) &  value<=40*div+minValue ) {
        color=172;
    } else if(value>(40*div+minValue) &  value<=41*div+minValue ) {
        color=176;
    } else if(value>(41*div+minValue) &  value<=42*div+minValue ) {
        color=180;
    } else if(value>(42*div+minValue) &  value<=43*div+minValue ) {
        color=184;
    } else if(value>(43*div+minValue) &  value<=44*div+minValue ) {
        color=188;
    } else if(value>(44*div+minValue) &  value<=45*div+minValue ) {
        color=192;
    } else if(value>(45*div+minValue) &  value<=46*div+minValue ) {
        color=196;
    } else if(value>(46*div+minValue) &  value<=47*div+minValue ) {
        color=200;
    } else if(value>(47*div+minValue) &  value<=48*div+minValue ) {
        color=204;
    } else if(value>(48*div+minValue) &  value<=49*div+minValue ) {
        color=208;
    } else if(value>(49*div+minValue) &  value<=50*div+minValue ) {
        color=212;
    } else if(value>(50*div+minValue) &  value<=51*div+minValue ) {
        color=216;
    } else if(value>(51*div+minValue) &  value<=52*div+minValue ) {
        color=220;
    } else if(value>(52*div+minValue) &  value<=53*div+minValue ) {
        color=224;
    } else if(value>(53*div+minValue) &  value<=54*div+minValue ) {
        color=228;
    } else if(value>(54*div+minValue) &  value<=55*div+minValue ) {
        color=232;
    } else if(value>(55*div+minValue) &  value<=56*div+minValue ) {
        color=236;
    } else if(value>(56*div+minValue) &  value<=57*div+minValue ) {
        color=240;
    } else if(value>(57*div+minValue) &  value<=58*div+minValue ) {
        color=244;
    } else if(value>(58*div+minValue)) {
        color=248;
    }

}