#include "pins.h"
#include "mbed.h"
#include "messen.h"
AnalogIn throttle(SPEED_PIN);
DigitalIn breake(BREAKE_PIN);
AnalogIn voltage(VOLTAGE_PIN);
AnalogIn current(CURRENT_PIN);

float getSpeed(){
  float speed = throttle.read() -0.27;
  if(speed < 0){          // meas0 isnt allowed to be <0 because its sets the pulsewidht of the pwm
    speed = 0;
  }
  speed *= 2;  // creates values between 0 and 1
  if(speed > 1){      // meas0 isnt allowed to be >1 because its sets the pulsewidth of the pwm 
    speed = 1;
  }
  return speed;
}

int getBreake(){
  int breake_value = breake.read();
  return breake_value;
}

float getVoltage(){
  float voltage_value = voltage.read();
  return voltage_value;
}

float getCurrent(){
  float current_value = current.read();
  return current_value;
}