
#include "mbed.h"

#define TIMER0_NUM_COUNTDOWNTIMERS  25

// status definition:
// 0            the timer has expired
// 1            10 ms Timer
// 2            Sekunden Timer
// 3            Minuten Timer
// 4            Stunden Timer
// 0xFF         Free timer


class timer0 {
  private:
    
    struct timerStruct
    {
      unsigned char status;           // siehe Beschreibung
      unsigned int count_timer;       // count down Zähler
    } CountDownTimers[TIMER0_NUM_COUNTDOWNTIMERS];    
    
    Ticker ticker;
  
  public:
    uint16_t counter;
    uint16_t countMillisecond;
    
    timer0();
    void func(void);
    uint8_t AllocateCountdownTimer (void);
    void RemoveCountdownTimer(uint8_t timer);
    uint8_t GetTimerStatus(uint8_t timer);
    uint16_t GetTimerZeit(uint8_t timer);
    void SetCountdownTimer(uint8_t timer, uint8_t status, uint16_t value);
};