#include "MODSERIAL.h"
#include "ventiel.h"

extern Serial pc;                       // definiert in main
extern Serial com;
//extern MODSERIAL com;                      // definiert in main

//--------------------------------------------------------
// Construktor initialisiert das Ventiel
ventiel::ventiel()
{
  v_var = 0;
}

void ventiel::set(uint8_t val)
{
  uint8_t wert1 = 0;
  
  //pc.printf("\nmagnet.set alt =  %02x parmeter = %d",v_var,val);
  
  
  if (val < 8)
  {
    // interne Variabel setzen
    wert1 = (1 << val);
    v_var |= wert1;
  }
  else
  {
     // alle Ventile auf 1 setzen
     v_var = 0xff;     
  }
 
  pc.printf("\nmagnet.set neu =  %02x verknuepfung = %02x\n",v_var,wert1); 
  
  // Alle Kanäle ausschalten
  //com.putc('9');        
  
  
  // aktive Kanäle einschalten
 
  for (uint8_t n = 0; n < 8; n++)
  {
    
    if ((v_var & (1 << n)) != 0)
    {
        char ch = 0x31 + n;
        //com.putc(ch); 
        //pc.printf("\nZeichenausgabe =  %c \n",ch);
        //wait_ms(10);  
    }
              
  } 
   com.printf(":AA0201%02xA5\n",v_var);
}

void ventiel::toggle(uint8_t val)
{
  uint8_t wert1 = 0;
  
  //pc.printf("\nmagnet.toggle alt =  %02x parmeter = %d",v_var,val);
  
  
  if (val < 8)
  {
    // interne Variabel setzen
    wert1 = (1 << val);
    if((v_var & wert1)==0){
        v_var |= wert1; 
        }else{
        v_var &= ~wert1;    
            
        }
  }
 
  pc.printf("\nmagnet.toggle neu =  %02x verknuepfung = %02x\n",v_var,wert1); 
  
  // Alle Kanäle ausschalten
  //com.putc('9');        
  
  
  // aktive Kanäle einschalten
 
  for (uint8_t n = 0; n < 8; n++)
  {
    
    if ((v_var & (1 << n)) != 0)
    {
        char ch = 0x31 + n;
        //com.putc(ch); 
        //pc.printf("\nZeichenausgabe =  %c \n",ch);
        //wait_ms(10);  
    }
              
  } 
   com.printf(":AA0201%02xA5\n",v_var);
}

void ventiel::reset(uint8_t val)
{

  uint8_t wert1 = 0;
  
  //pc.printf("\nmagnet.reset alt =  %02x parameter = %d",v_var,val);
  
  if (val < 8)
  {
      // interne Variabel setzen
      wert1 = ~(1 << val);
      v_var &= wert1;  
  }
  else
  {
      // alle Ventile auf 1 setzen
      v_var = 0x00;     
  }
 
  pc.printf("\nmagnet.reset neu =  %02x, verknuepfung = %02x\n",v_var,wert1);  
   
   // Alle Kanäle ausschalten
//com.putc('9');        
  
  com.printf(":AA0201%02xA5\n",v_var);
 
  
  // aktive Kanäle einschalten
  for (uint8_t n = 0; n < 8; n++)
  {
    if ((v_var & (1 << n)) != 0) 
    {
        char ch = 0x31 + n;
        //com.putc(ch);
        //pc.printf("\nZeichenausgabe =  %c \n",ch);
        //wait_ms(10);
    }             
  }  


   
}

bool ventiel::get(uint8_t val)
{
  if ((v_var & (1 << val)) == 0) return false;
  else                          return true;    
}
