/**
 * @file main.c
 * @brief ILI9163/DL144128TF 128x128 TFT LCD Test code
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Jun Morita (iccraft)
 *
 * @copyright   Copyright (C) 2012 Simon Inns
 * @author Simon Inns <simon.inns@gmail.com>
 */

#include "mbed.h"
#include "ili9163lcd.h"

ILI9163 TFT(D2,D3,D4,D5,D6);

int main()
{

    TFT.lcdInitialise(LCD_ORIENTATION2);
    
    TFT.lcdClearDisplay(Black);
    
    TFT.lcdLine(0, 0, 127, 127, White);
    TFT.lcdLine(0, 127, 127, 0, White);
    TFT.lcdCircle(64, 64, 32, Red);
    TFT.lcdCircle(64, 64, 40, Blue);
    TFT.lcdCircle(64, 64, 48, Green);
    
    TFT.lcdFilledRectangle(62, 62, 65, 65, Green);
    
    TFT.set_font((unsigned char*)font11x16); 
    TFT.lcdPutS("Hallo", TFT.lcdTextX(2), TFT.lcdTextY(0),Black, White);
    //TFT.lcdPutS("Hello World!", TFT.lcdTextX(4), TFT.lcdTextY(0), Blue, Cyan);  // Vordergund, Hintergrund
    
    TFT.set_font((unsigned char*)font5x8);
    TFT.lcdPutS("The quick brown fox jumped over the lazy dog 0123456789", TFT.lcdTextX(0), TFT.lcdTextY(4), Black, Magenta);
    
    
    while(1)
    {

    }
}
