#include "mbed.h"

DigitalIn K1 (dp25);    //Keuzeschakelaar stand 1: Sumo.
DigitalIn K2 (dp16);    //Keuzeschakelaar stand 2: Straight line.

AnalogIn SA (dp9);    //Sensor achter
AnalogIn SRV (dp10);    //Sensor rechts voor.
AnalogIn SLV (dp11);    //Sensor links achter.

DigitalOut MLL (dp4);  //Draairichting linker motor linksom.
DigitalOut MLR (dp6);  //Draairichting linker motor rechtsom.
DigitalOut MRL (dp1);  //Draairichting rechter motor linksom.
DigitalOut MRR (dp24);  //Draairichting rechter motor rechtsom.
DigitalOut LED (dp28);  //Indicatie LED.

PwmOut ML (dp18);   //PWM-signaal voor de linker motor.
PwmOut MR (dp2);   //PWM-signaal voor de rechter motor.

int main()
{
    while (1)
    {
        if (K1) //sumo stand
        {
            if (SLV > 0.2 && SRV > 0.2) //als beide sensoren zwart zien. rijdt vooruit.
            {
                LED = true;
                MLL = true;
                MRR = true;
                MRL = false;
                MLR = false;
                wait (0.1);
            }
            
            if (SLV <= 0.2 || SRV <= 0.2) //als 1 van beide sensoren wit ziet
            {
                LED = true;
                MLL = false;//robot rijdt achteruit
                MRR = false;
                MLR = true;
                MRL = true;
                ML = 1.0;
                MR = 1.0;
                wait (1);
                MLL = true;//robot draait om
                MRR = false;
                MRL = true;
                MLR = false;
                wait (1);
                
            }
           
        }
        if (K2) //rechte lijn stand
        {
            LED = true;
            wait (2); //even wachten voor het rijden
            MLL = true;
            MRR = true;
            MRL = false;
            MLR = false;
            ML = 1.0;
            MR = 1.0;
            wait (6);//6 seconden rijden
            MLL = false;
            MRR = false;
            MRL = false;
            MLR = false;
            ML = 0.0;
            MR = 0.0;
            wait (60);//stoppen en 1 minuut niks doen
        }
    }
}
