#include "mbed.h"
#include <ctime>
#include <cstdlib>

#define AIRCON 8                                                                // Aircon Value     8
#define WASHER 4                                                                // Washer Value     4
#define FRIDGE 2                                                                // Fridge Value     2
#define TV 1                                                                    // TV Value         1
#define STANDBY 0 

I2C i2c_1( p9, p10);
I2C i2c_2(p28, p27);


//On mbed leds for debugging
DigitalOut myled1(LED1);                                                        // mbed LED 1
DigitalOut myled2(LED2);                                                        // mbed LED 2
DigitalOut myled3(LED3);                                                        // mbed LED 3


//Sets up switches
DigitalIn s_aircon(p13);                                                        // Aircon Switch
DigitalIn s_washer(p12);                                                        // Washer Switch
DigitalIn s_fridge(p11);                                                        // Fridge Switch
DigitalIn s_tv(p8);                                                             // TV Switch
DigitalIn s_standby(p7);                                                        // Standby Switch
int ss_aircon=0;
int ss_washer=0;
int ss_fridge=0;
int ss_tv=0;
int ss_standby=0;

//Sets up switch lights
DigitalOut l_aircon(p25);                                                       // Aircon Light
DigitalOut l_washer(p24);                                                       // Washer Light
DigitalOut l_fridge(p21);                                                       // Fridge Light
DigitalOut l_tv(p22);                                                           // TV Light
DigitalOut l_standby(p23);                                                      // Standby Light
DigitalOut ledmeter(p5);                                                        // Digital Meter Light

//Sets up MOTOR
PwmOut PWM4(LED4);                                                              // LED PWM
PwmOut PWMmotor(p26); // STEPPER motor Assign a PWM1 as pin21                   // Motor PWM
DigitalOut motor_dir(p29);                                                      // Motor Direction
//debug LED

int autosw=0;
int steplevel=0;
int numpress=0;
int lastpressstate=0;
Ticker autotimer;
Ticker presstimer;

//External switches
DigitalIn sw3(p14);
DigitalIn sw4(p30);

//DigitalOut meas1_load(p30);
AnalogIn meas1_vol(p15);
AnalogIn meas1_cur_H(p16);
AnalogIn meas1_cur_L(p17);

// for external led
Ticker t_led;
volatile float t_led_flash_period;
float t_led_flash_p;
float t_led_on_time=0.04;
int autosw_up = 1;                                                              //Auto switch climb up
int rand_count = 0;


//DigitalOut meas2_load(p14);
AnalogIn meas2_vol(p18);
AnalogIn meas2_cur_H(p19);
AnalogIn meas2_cur_L(p20);

void turn_led_on();
void turn_led_off();

void turn_led_on()                                                              
{
    myled2=1;                                                                   // Turns mbed LED2 ON
    ledmeter=1;                                                                 // Turns Digital Meter LED ON
    t_led.detach();                                                             // Detach function from Ticker
    t_led.attach(&turn_led_off, t_led_on_time);                                 // Attach LED OFF Function to ticker for LED ON Time
}

void turn_led_off()
{
    myled2=0;                                                                   // Turns mbed LED2 OFF
    ledmeter=0;                                                                 // Turns Digital Meter LED OFF
    t_led.detach();                                                             // Detach function from Ticker
    t_led.attach(&turn_led_on, t_led_flash_period-t_led_on_time);               // Attach LED ON Function to ticker for LED OFF Time

}

void increment_auto()                                                           // AutoSwitch Counter
{
    if(autosw_up==1){
        steplevel++;
    } else {
        steplevel--;
    }
}

void random_auto()
{
    srand(rand_count);
    int app = rand()%4;
    int app_pow = pow(2.0,app);
    if(steplevel&app_pow){
        steplevel -= app_pow;
    } else {
        steplevel += app_pow;
    }
    rand_count++;
}

void resetnumpress()                                                            // Resets AutoSwitch start process
{
    numpress=0;
    presstimer.detach();
}


int main()
{    
    //switch test setup
    int thepast;
    int atimer=0;
    int lights_on=0;
    
    int autosw_mode = 0;                                                        // 0 = climb up then reset | 1 = climb up then down
    
    //light setup
    l_aircon=0;                                                                 // Appliance Switch LED's Start OFF
    l_washer=0;
    l_fridge=0;
    l_tv=0;
    l_standby=0;
    
    float w=0.25;                                                               // Appliances Switch LED's turn ON in sequence
    l_standby=1;
    wait(w);
    l_tv=1;
    wait(w);
    l_fridge=1;
    wait(w);
    l_washer=1;
    wait(w);
    l_aircon=1;
    wait(1.0);                                                                  // Appliance switch LED's turn OFF
    l_aircon=0;
    l_washer=0;
    l_fridge=0;
    l_tv=0;
    l_standby=0;

    //motor setup
    float t_step_period= 0;
    motor_dir=0;
    int appliance_select_set = 17;

    int standbyi=0;
    float autotimertime=5.0;

    while(1) {

        int appliance_select = -1;

        ss_standby=s_standby;                                                   // Save Switch state for loop
        ss_aircon=s_aircon;
        ss_tv=s_tv;
        ss_fridge=s_fridge;
        ss_washer=s_washer;
        
        standbyi=ss_standby;
        if (standbyi!=lastpressstate){
            lastpressstate=standbyi;
            numpress++;
            presstimer.attach(&resetnumpress,3.0);
        }

        if (numpress > 4 && lastpressstate==1 && autosw==0){                    // If Standby Switch has been pressed 4 times, the last press is on and its not already AutoSwitching
            autosw=1;                                                           // Autoswitching ON
            numpress=0;                                                         // Set Press count to 0
            steplevel=0;                                                        // Reset Step Counter
            
            l_standby=1;                                                         // LED sequence
            wait(0.1);
            //l_standby = 0;
            l_tv = 1;
            wait(0.1);
            l_tv = 0;
            l_fridge = 1;
            wait(0.1);
            l_fridge = 0;
            l_washer = 1;
            wait(0.1);
            l_washer = 0;
            l_aircon = 1;
            wait(0.1);
            l_aircon = 0;
            
            wait(0.8);
            
            l_aircon=1;                                                         // LED sequence
            l_washer=1;
            l_fridge=1;
            l_tv=1;
            l_standby=1;
            
            wait(0.8);
            
            l_aircon=0;                                                         // LED sequence
            l_washer=0;
            l_fridge=0;
            l_tv=0;
            //l_standby=0;


            autotimertime=30.0; //5                                                 // Default Timer
            
            if (ss_tv==1) {                                                     
                autosw_mode = 1;                                                //Autosw climb up then down
             } else {
                autosw_mode = 0;                                                //Autosw climb up then reset
             }

            if (ss_washer==1) {                                                 // Adjust Timer with other Appliance Switches
                autotimertime+=15.0;
             }
            if (ss_aircon==1) {
                autotimertime+=30.0;
             }
            if (ss_fridge==1) 
             {
                 autotimer.attach(&random_auto,autotimertime);
             }
             else 
             {
                autotimer.attach(&increment_auto,autotimertime);                    // Set autotimer for Appliance Sequence
             }
            
                
        }

//int steplevel=0;
//int numpress=0;
//int lastpressstate=0;

        
        if (autosw==1){
            if (ss_standby == 1){
                
                appliance_select = STANDBY;
                l_standby=1;
                
                if (steplevel>15) {                                            // If the sequence has reached its end
                    if (autosw_mode == 1){ steplevel = 15; autosw_up = 0; }
                    else { steplevel = 0; autosw_up = 1; } 
                }
                if (steplevel==0){ autosw_up = 1; }
                if (steplevel&1) { appliance_select+=TV; l_tv=1; }
                else { l_tv=0; }
                if (steplevel&2) { appliance_select+=FRIDGE; l_fridge=1; }
                else { l_fridge=0; }
                if (steplevel&4) { appliance_select+=WASHER; l_washer=1;}
                else { l_washer=0; }
                if (steplevel&8) { appliance_select+=AIRCON; l_aircon=1; } 
                else { l_aircon=0; }
                
                switch(appliance_select) {
                    case 0 : t_step_period = 0.0085000; break;                              // If appliance select is 0 then only standby is on
                    case 1 : t_step_period = 0.0063125; break;
                    case 2 : t_step_period = 0.0039600; break;
                    case 3 : t_step_period = 0.0030025; break;
                    case 4 : t_step_period = 0.0025425; break;                                    
                    case 5 : t_step_period = 0.0021425; break;
                    case 6 : t_step_period = 0.0017925; break;
                    case 7 : t_step_period = 0.0015800; break;
                    case 8 : t_step_period = 0.0014450; break;                                   
                    case 9 : t_step_period = 0.0013000; break;
                    case 10 : t_step_period = 0.0011600; break;
                    case 11 : t_step_period = 0.0010650; break;
                    case 12 : t_step_period = 0.0009950; break;                                  
                    case 13 : t_step_period = 0.0009275; break;
                    case 14 : t_step_period = 0.0008600; break;
                    case 15 : t_step_period = 0.0007900; break;
                    default : printf("Nothing pressed"); 
                }
            }
            else {
                autosw=0;
                autotimer.detach();
            }
        } 
            
        else if (ss_standby==1) {

            l_standby=1;
            appliance_select = 0;
            if (ss_aircon==1) {appliance_select += AIRCON; l_aircon=1; }        // If Aircon switch is ON, Add Aircon value to PWM value
            else { l_aircon=0; }                                                // Else turn Aircon LED OFF
            if (ss_tv==1) {appliance_select += TV; l_tv =1; }                   // If TV switch is ON, Add TV value to PWM value
            else { l_tv=0; }                                                    // Else turn TV LED OFF
            if (ss_fridge==1) {appliance_select += FRIDGE; l_fridge=1; }        // If Fridge switch is ON, Add Fridge value to PWM value
            else { l_fridge=0; }                                                // Else turn Fridge LED OFF  
            if (ss_washer==1) {appliance_select += WASHER; l_washer=1; }        // If Washer switch is ON, Add Washer value to PWM value
            else { l_washer=0; }                                                // Else turn Washer LED OFF 
        

            switch(appliance_select) {
                case 0 : t_step_period = 0.0085000; break;                              // If appliance select is 0 then only standby is on
                case 1 : t_step_period = 0.0063125; break;
                case 2 : t_step_period = 0.0039600; break;
                case 3 : t_step_period = 0.0030025; break;
                case 4 : t_step_period = 0.0025425; break;                                    
                case 5 : t_step_period = 0.0021425; break;
                case 6 : t_step_period = 0.0017925; break;
                case 7 : t_step_period = 0.0015800; break;
                case 8 : t_step_period = 0.0014450; break;                                   
                case 9 : t_step_period = 0.0013000; break;
                case 10 : t_step_period = 0.0011600; break;
                case 11 : t_step_period = 0.0010650; break;
                case 12 : t_step_period = 0.0009950; break;                                  
                case 13 : t_step_period = 0.0009275; break;
                case 14 : t_step_period = 0.0008600; break;
                case 15 : t_step_period = 0.0007900; break;
                default : printf("Nothing pressed"); 
            }
        }
        
        else {
            appliance_select=-1;                                                      // Else Stop Motor
            l_standby=0;                                                        // Turn all LEDs OFF
            l_aircon=0;
            l_washer=0;
            l_fridge=0;
            l_tv=0;
        }
        
        if (appliance_select_set!=appliance_select) {

            appliance_select_set=appliance_select;
        
            //if nothing pressed
            if (appliance_select<0) {
                t_step_period = 100;
                PWMmotor=0;
                PWM4=0;
                PWMmotor.period(t_step_period);
                PWM4.period(t_step_period);
            } else {
            
                PWM4=0.95;
                PWM4.period(t_step_period);

                PWMmotor=0.95;
                PWMmotor.period(t_step_period);
                t_step_period = t_step_period-0.00001;

                PWMmotor.pulsewidth(t_step_period);
                PWM4.pulsewidth(t_step_period);

            }
            
        wait(0.3);
        
        }
    }
}

